<?php

namespace App\Http\Controllers;

use App\Http\Requests\AdminStoreStoreRequest;
use App\Http\Requests\StoreStoreRequest;
use App\Models\Store;
use App\Models\User;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Storage;

class AdminStoreController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(User $user)
    {
        return inertia('Store/Admin/Index', [
            'user' => User::query()->with('store')->where('id', $user->id)->first(),
            'store' => Store::query()->where('user_id', $user->id)->first(),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create($userId)
    {
        return inertia('Store/Admin/Create', [
            'userId' => $userId,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(AdminStoreStoreRequest $request, User $user)
    {
        if ($request->logo) {
            $image = explode('base64,', $request->logo);
            $image = end($image);
            $image = str_replace(' ', '+', $image);
            $file = $user->name . uniqid() . '.jpg';

            $result = Storage::disk('public')->put("store/" . $file, base64_decode($image));
            if (!$result) {
                return Redirect::back()->with('error', 'Image upload failed, please try again');
            }

            Store::create([
                'name' => $request->name,
                'description' => $request->description,
                'logo' => $file,
                'plan' => $request->plan,
                'user_id' => $user->id,
            ]);
        } else {
            Store::create([
                'name' => $request->name,
                'description' => $request->description,
                'plan' => $request->plan,
                'user_id' => $user->id,
            ]);
        }
        return to_route('user.store.index', $user->id)->with('success', "Store created successfully");
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Store $store)
    {
        return inertia('Store/Admin/Edit', [
            'store' => $store,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(AdminStoreStoreRequest $request, Store $store)
    {

        if ($request->logo) {
            $image = explode('base64,', $request->logo);
            $image = end($image);
            $image = str_replace(' ', '+', $image);
            $file = uniqid() . '.jpg';
            Storage::disk('public')->delete("store/" . $store->logo);
            $result = Storage::disk('public')->put("store/" . $file, base64_decode($image));
            if (!$result) {
                return Redirect::back()->with('error', 'Image upload failed, please try again');
            }

            $store->update([
                'name' => $request->name,
                'description' => $request->description,
                'logo' => $file,
                'plan' => $request->plan,
            ]);
        } else {
            $store->update([
                'name' => $request->name,
                'description' => $request->description,
                'plan' => $request->plan,
            ]);
        }

        return Redirect::back()->with('success', 'Store dtails updated successfully');
    }

}
