<?php

namespace App\Http\Controllers;

use App\Http\Requests\ContactStoreRequest;
use App\Models\Contact;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Inertia\Inertia;

class ContactController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        if ($request->has('search')) {
            $contacts = Contact::query()
                ->where('email', 'like', $request->search . '%')
                ->orWhere('subject', 'like', $request->search . '%')
                ->paginate(100);
        } else {
            $contacts = Contact::query()->paginate(15);
        }

        return Inertia::render('Contact/Index', [
            'contacts' => $contacts
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return Inertia::render('Contact/Create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(ContactStoreRequest $request)
    {
        Contact::create($request->validated());
        return Redirect::back()->with('success', 'Thanks for your message, we will contact you soon.');
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Contact $contact)
    {
        $contact->delete();
        return Redirect::back()->with('success','Feedback deleted successfully!');
    }
}
