# Installation
> `npm install --save @types/react-modal-image`

# Summary
This package contains type definitions for react-modal-image (https://github.com/aautio/react-modal-image#readme).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/react-modal-image.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/react-modal-image/index.d.ts)
````ts
import * as React from "react";

export interface ModalImageProps extends React.ImgHTMLAttributes<HTMLImageElement> {
    /* The small image to display */
    small: string;

    /* The srcset attribute for the small image */
    smallSrcSet?: string;

    /* The medium image to display */
    medium?: string;

    /* The large image to display */
    large?: string;

    /* The alt tag for the image */
    alt?: string;

    /* Should the download button be hidden? */
    hideDownload?: boolean;

    /* Should the zoom button be hidden? */
    hideZoom?: boolean;

    /* Should the rotate button be shown? */
    showRotate?: boolean;

    /* The color to display in the background. */
    imageBackgroundColor?: string;

    /* The class name for the modal */
    className?: string;
}

declare class ModalImage extends React.Component<ModalImageProps> {}
declare class Lightbox extends React.Component<ModalImageProps> {}

export default ModalImage;
export { Lightbox };

````

### Additional Details
 * Last updated: Tue, 07 Nov 2023 09:09:39 GMT
 * Dependencies: [@types/react](https://npmjs.com/package/@types/react)

# Credits
These definitions were written by [Steel](https://github.com/CodeSteel).
