"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pixel_blue_imgdata = exports.invert_imgdata = exports.darkify_imgdata = exports.incbrightness_two_imgdata = exports.incbrightness_imgdata = exports.sat_adj_imgdata = void 0;
const helpers_1 = require("./helpers");
let i, addition1, addition2, addition;
const darkify_imgdata = (imgData, dec_amt) => {
    let BRIGHTNESS_ADJ = dec_amt;
    for (i = 0; i < imgData.data.length; i += 4) {
        if (imgData.data[i] - BRIGHTNESS_ADJ >= 0) {
            imgData.data[i] -= BRIGHTNESS_ADJ;
        }
        if (imgData.data[i + 1] - BRIGHTNESS_ADJ >= 0) {
            imgData.data[i + 1] -= BRIGHTNESS_ADJ;
        }
        if (imgData.data[i + 2] - BRIGHTNESS_ADJ >= 0) {
            imgData.data[i + 2] -= BRIGHTNESS_ADJ;
        }
    }
    return imgData;
};
exports.darkify_imgdata = darkify_imgdata;
const incbrightness_imgdata = (imgData, inc_amt) => {
    let BRIGHTNESS_ADJ = 20;
    for (i = 0; i < imgData.data.length; i += 4) {
        imgData.data[i] += BRIGHTNESS_ADJ;
        imgData.data[i + 1] += BRIGHTNESS_ADJ;
        imgData.data[i + 2] += BRIGHTNESS_ADJ;
    }
    return imgData;
};
exports.incbrightness_imgdata = incbrightness_imgdata;
const incbrightness_two_imgdata = (imgData) => {
    let BRIGHTNESS_ADJ = 80;
    for (i = 0; i < imgData.data.length; i += 4) {
        imgData.data[i] += BRIGHTNESS_ADJ;
        imgData.data[i + 1] += BRIGHTNESS_ADJ;
        imgData.data[i + 2] += BRIGHTNESS_ADJ;
    }
    return imgData;
};
exports.incbrightness_two_imgdata = incbrightness_two_imgdata;
const invert_imgdata = (imgData) => {
    for (i = 0; i < imgData.data.length; i += 4) {
        imgData.data[i] = 255 - imgData.data[i];
        imgData.data[i + 1] = 255 - imgData.data[i + 1];
        imgData.data[i + 2] = 255 - imgData.data[i + 2];
    }
    return imgData;
};
exports.invert_imgdata = invert_imgdata;
const sat_adj_imgdata = (imgData) => {
    let SAT_ADJ = 150;
    for (i = 0; i < imgData.data.length; i += 4) {
        imgData.data[i] -= SAT_ADJ;
        imgData.data[i + 1] -= SAT_ADJ;
        imgData.data[i + 2] -= SAT_ADJ;
    }
    return imgData;
};
exports.sat_adj_imgdata = sat_adj_imgdata;
const pixel_blue_imgdata = (imgData) => {
    let randomNumber = 0;
    for (i = 0; i < imgData.data.length; i += 4) {
        randomNumber = (0, helpers_1.getRandomNumber)(0, 200);
        let addition = 0;
        if (randomNumber > 0 && randomNumber < 50) {
            addition1 = 0;
            addition2 = 30;
        }
        else if (randomNumber > 49 && randomNumber < 100) {
            addition1 = 100;
            addition2 = 90;
        }
        else {
            addition1 = 70;
            addition2 = 10;
        }
        if (imgData.data[i] - addition > 255) {
            imgData.data[i] -= addition;
        }
        else {
            imgData.data[i] += addition;
        }
        if (imgData.data[i + 1] + addition > 255) {
            imgData.data[i + 1] -= addition2;
        }
        else {
            imgData.data[i + 2] += addition2;
        }
    }
    return imgData;
};
exports.pixel_blue_imgdata = pixel_blue_imgdata;
