import { Link } from "@inertiajs/react";
import { Button } from "./ui/button";
import { ArrowRight, Contact, House, LogIn } from "lucide-react";
import { PageProps } from "@/types";
import { url } from "@/lib/url";

const Header = ({ auth }: PageProps) => {
    return (
        <header className="flex flex-col md:flex-row justify-between items-center gap-2 py-5 lg:grid-cols-3 -mt-8">
            <Link href="/">
                <img
                    src={`${url}/images/logo.jpg`}
                    className="rounded-xl p-5 w-24 h-24"
                    alt="logo"
                />
            </Link>

            <nav className="-mx-3 flex flex-1 justify-start md:justify-end flex-wrap">
                {auth.user ? (
                    <>
                        <Link
                            href={"/"}
                            className="rounded-md px-3 py-2 text-black ring-1 ring-transparent transition hover:text-black/70 focus:outline-none focus-visible:ring-[#FF2D20] dark:text-white dark:hover:text-white/80 dark:focus-visible:ring-white"
                            prefetch
                            cacheFor="5m"
                        >
                            <p className="ml-1">Home</p>
                        </Link>
                        <Link
                            href={route("contact.create")}
                            className="rounded-md px-3 py-2 text-black ring-1 ring-transparent transition hover:text-black/70 focus:outline-none focus-visible:ring-[#FF2D20] dark:text-white dark:hover:text-white/80 dark:focus-visible:ring-white"
                            prefetch
                        >
                            <p className="ml-1">Contact Us</p>
                        </Link>
                        <Link
                            href={route("dashboard")}
                            className="rounded-md px-3 py-2 text-black ring-1 ring-transparent transition hover:text-black/70 focus:outline-none focus-visible:ring-[#FF2D20] dark:text-white dark:hover:text-white/80 dark:focus-visible:ring-white"
                            prefetch
                        >
                            <div className="flex justify-center items-center">
                                <p>Dashboard</p>
                                <ArrowRight
                                    size={18}
                                    className="text-blue-700"
                                />
                            </div>
                        </Link>
                    </>
                ) : (
                    <>
                        <Link
                            href="/"
                            className="rounded-md px-3 py-2 text-black ring-1 ring-transparent transition hover:text-black/70 focus:outline-none focus-visible:ring-[#FF2D20] dark:text-white dark:hover:text-white/80 dark:focus-visible:ring-white"
                            prefetch
                        >
                            <Button
                                variant={"outline"}
                                className="hover:scale-105 transition-all"
                            >
                                <House size={18} className="text-blue-700" />
                                <p className="ml-1">Home</p>
                            </Button>
                        </Link>
                        <Link
                            href={route("contact.create")}
                            className="rounded-md px-3 py-2 text-black ring-1 ring-transparent transition hover:text-black/70 focus:outline-none focus-visible:ring-[#FF2D20] dark:text-white dark:hover:text-white/80 dark:focus-visible:ring-white"
                            prefetch
                        >
                            <Button
                                variant={"outline"}
                                className="hover:scale-105 transition-all"
                            >
                                <Contact size={18} className="text-blue-700" />
                                <p className="ml-1">Contact Us</p>
                            </Button>
                        </Link>
                        <Link
                            href={route("login")}
                            className="rounded-md px-3 py-2 text-black ring-1 ring-transparent transition hover:text-black/70 focus:outline-none focus-visible:ring-[#FF2D20] dark:text-white dark:hover:text-white/80 dark:focus-visible:ring-white"
                            prefetch
                        >
                            <Button
                                variant={"outline"}
                                className="hover:scale-105 transition-all"
                            >
                                <p className="mr-1"> Log in</p>
                                <LogIn size={18} className="text-blue-700" />
                            </Button>
                        </Link>
                    </>
                )}
            </nav>
        </header>
    );
};

export default Header;
