import "react-responsive-carousel/lib/styles/carousel.min.css"; // requires a loader
import { Carousel } from "react-responsive-carousel";
import { url } from "@/lib/url";

export default function ImageSlider({ images }: { images: Array<string> }) {
    return (
        <Carousel
            autoPlay={true}
            emulateTouch={true}
            infiniteLoop={true}
            swipeable={true}
            interval={3000}
            width="80%"
            dynamicHeight={false}
        >
            {images.map((image) => (
                <div key={image}>
                    <img src={`${url}/storage/products/${image}`} />
                </div>
            ))}
        </Carousel>
    );
}
