import { Link } from "@inertiajs/react";
import { ArrowLeftCircle } from "lucide-react";

export default function NotFound({ id }: { id: string }) {
    return (
        <>
            <div className="flex items-center justify-center min-h-screen bg-cover bg-center bg-no-repeat">
                <div className="max-w-md mx-auto text-center bg-white bg-opacity-90 p-8 rounded-lg shadow-lg">
                    <div className="text-9xl font-bold text-red-700 mb-4">
                        404
                    </div>
                    <h1 className="text-4xl font-bold text-gray-800 mb-6">
                        Product Not Found
                    </h1>
                    <p className="text-lg text-gray-600 mb-8">
                        The page you're looking for seems to have gone on a
                        little adventure. Don't worry, we'll help you find your
                        way back home.
                    </p>
                    <Link
                        href={route("store.display.index", id)}
                        className="flex justify-center items-center gap-2 bg-indigo-600 text-white font-semibold px-6 py-3 rounded-md hover:bg-indigo-700 transition-colors duration-300"
                    >
                        <ArrowLeftCircle /> Go Back
                    </Link>
                </div>
            </div>
        </>
    );
}
