import { Link } from "@inertiajs/react";
import { ArrowLeftToLine, ArrowRightToLine } from "lucide-react";

export default function Pagination({ links }: { links: any }) {
    function getClassName(active: boolean) {
        if (active) {
            return "mr-1 mb-1 px-2 py-1 text-sm leading-4 border rounded hover:bg-white focus:border-primary focus:text-primary bg-blue-700 text-white";
        } else {
            return "mr-1 mb-1 px-2 py-1 text-sm leading-4 border rounded hover:bg-white focus:border-primary focus:text-primary";
        }
    }

    return (
        links.length > 3 && (
            <div className="mb-4">
                <div className="flex flex-wrap mt-8">
                    {
                        //@ts-ignore
                        links.map((link, key) =>
                            link.url === null ? (
                                <div
                                    key={key}
                                    className="mr-1 mb-1 px-2 py-1 text-sm leading-4 text-gray-400 border rounded"
                                >
                                    {link.label === "&laquo; Previous" ? (
                                        <ArrowLeftToLine />
                                    ) : link.label === "Next &raquo;" ? (
                                        <ArrowRightToLine />
                                    ) : (
                                        link.label
                                    )}
                                </div>
                            ) : (
                                <Link
                                    key={key}
                                    className={getClassName(link.active)}
                                    href={link.url}
                                >
                                    {link.label === "&laquo; Previous" ? (
                                        <ArrowLeftToLine />
                                    ) : link.label === "Next &raquo;" ? (
                                        <ArrowRightToLine />
                                    ) : (
                                        link.label
                                    )}
                                </Link>
                            )
                        )
                    }
                </div>
            </div>
        )
    );
}
