import { FormEventHandler } from "react";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import InputError from "@/Components/InputError";
import InputLabel from "@/Components/InputLabel";
import PrimaryButton from "@/Components/PrimaryButton";
import TextInput from "@/Components/TextInput";
import { Head, Link, useForm, usePage } from "@inertiajs/react";
import { ArrowLeft, SaveAll } from "lucide-react";

export default function Create() {

    const {errors} = usePage().props;

    const { data, setData,post,processing } = useForm({
        name: "",
    });

    const submit: FormEventHandler = (e) => {
        e.preventDefault();

        post(route("category.store"));
    };

    return (
        <AuthenticatedLayout>
            <Head title="Category" />

            <div className="flex justify-center items-center mt-10">
            <form onSubmit={submit} className="w-96 bg-white p-7 rounded-lg">
                 <Link href={route('category.index')}>
                    <ArrowLeft size={16} className="mb-3" />
                </Link>
                <div>
                    <InputLabel htmlFor="name" value="Name" />

                    <TextInput
                        id="name"
                        name="name"
                        value={data.name}
                        className="mt-1 block w-full"
                        autoComplete="name"
                        isFocused={true}
                        onChange={(e) => setData("name", e.target.value)}
                        required
                    />

                    <InputError message={errors.name} className="mt-2" />
                </div>

                <div className="flex items-center justify-end mt-4">

                    <PrimaryButton className="ms-4 w-full flex justify-center items-center" disabled={processing}>
                        Save &nbsp;<SaveAll size={14} />
                    </PrimaryButton>
                </div>
            </form>
            </div>
        </AuthenticatedLayout>
    );
}
