import { Button } from "@/Components/ui/button";
import { Table, TableBody, TableCaption, TableCell, TableHead, TableHeader, TableRow } from "@/Components/ui/table";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { Head, Link } from "@inertiajs/react";
import { Edit, Edit2, PlusCircle } from "lucide-react";
import { Category } from "@/types/custom";
import { DeleteCategory } from "./DeleteCategory";

export default function Index({categories}:{categories:Category[]}) {
  
    return (
        <AuthenticatedLayout>
            <Head title="Contacts" />

            <div className="py-10">
                <div className="max-w-full md:max-w-2xl mx-auto sm:px-6 lg:px-8">
                    <div className="bg-white overflow-hidden shadow-sm sm:rounded-lg mt-1">
                        <div className="p-6 text-gray-900">
                            <Link href={route('category.create')}>
                                <Button variant={"outline"}>
                                    <PlusCircle size={14} /> &nbsp;
                                    Add New Category
                                </Button>
                            </Link>
                            <Table>
                                <TableCaption>List of categories.</TableCaption>
                                <TableHeader>
                                    <TableRow>
                                        <TableHead>
                                            Category Name
                                        </TableHead>
                                        <TableHead>Edit</TableHead>
                                        <TableHead>Delete</TableHead>
                                    </TableRow>
                                </TableHeader>
                                <TableBody>
                                    {
                                        categories.map((category)=>(
                                            <TableRow key={category.id}>
                                                <TableCell>{category.name}</TableCell>
                                                <TableCell>
                                                <Link href={route('category.edit', category.id)}>
                                                    <Button variant={"outline"}>
                                                        <Edit size={18} color="green" />
                                                    </Button>
                                                </Link>
                                                </TableCell>
                                                <TableCell>
                                                    <DeleteCategory id={category.id} />
                                                </TableCell>
                                            </TableRow>
                                        ))
                                    }
                                </TableBody>
                            </Table>
                        </div>
                    </div>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
