import Footer from "@/Components/Footer";
import Header from "@/Components/Header";
import { PageProps } from "@/types";
import { Head, useForm } from "@inertiajs/react";
import { Facebook, Instagram, Mail, Phone, Send } from "lucide-react";

const Create = ({ auth, flash }: PageProps) => {
    const { data, setData, post, processing, errors, reset } = useForm({
        name: "",
        email: "",
        subject: "",
        message: "",
    });

    const handleSubmit = (e: React.FormEvent) => {
        e.preventDefault();
        post(route("contact.store"), {
            onSuccess: () => {
                reset();
            },
        });
    };

    return (
        <>
            <Head title="Contact" />

            <div className="bg-gray-100 text-black/50 dark:bg-black dark:text-white/50">
                <div className="relative min-h-screen flex flex-col items-center justify-center selection:bg-[#FF2D20] selection:text-white">
                    <div className="relative w-full max-w-2xl px-6 lg:max-w-7xl">
                        <Header auth={auth} />
                        <main className="mt-6">
                            <div className="grid gap-6 lg:grid-cols-2 lg:gap-8">
                                <div>
                                    <h1 className="text-blue-700 text-2xl font-bold">
                                        Contact us
                                    </h1>
                                    <p className="text-sm text-gray-900 mt-4">
                                        Have some big idea or brand to develop
                                        and need help? Then reach out we'd love
                                        to hear about your idea and provide
                                        help.
                                    </p>

                                    <div className="mt-12">
                                        <ul className="mt-4">
                                            <li className="flex items-center">
                                                <div className="bg-[#e6e6e6cf] h-10 w-10 rounded-full flex items-center justify-center shrink-0">
                                                    <Phone
                                                        size={18}
                                                        className="text-blue-700"
                                                    />
                                                </div>
                                                <a
                                                    href="tel:+93777080123"
                                                    className="text-gray-800  text-sm ml-4"
                                                >
                                                    <p className="text-lg text-blue-700 font-semibold">
                                                        +93777080123
                                                    </p>

                                                    <p className="text-lg text-blue-700 font-semibold">
                                                        +93749545050
                                                    </p>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>

                                    <div className="mt-12">
                                        <ul className="mt-4">
                                            <li className="flex items-center">
                                                <div className="bg-[#e6e6e6cf] h-10 w-10 rounded-full flex items-center justify-center shrink-0">
                                                    <Mail
                                                        size={18}
                                                        className="text-blue-700"
                                                    />
                                                </div>
                                                <a
                                                    href="mailto:easy.24.link@gmail.com"
                                                    className="text-gray-800 text-sm ml-4"
                                                >
                                                    <p className="text-lg text-blue-700 font-semibold">
                                                        easy.24.link@gmail.com
                                                    </p>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>

                                    <div className="mt-12">
                                        <ul className="flex mt-4 space-x-4">
                                            <li className="bg-[#e6e6e6cf] h-10 w-10 rounded-full flex items-center justify-center shrink-0">
                                                <a
                                                    href="https://www.facebook.com/people/Abdulwahab-Rezaie/61565938258257/?mibextid=ZbWKwL"
                                                    target="_blank"
                                                >
                                                    <Facebook
                                                        size={24}
                                                        className="text-blue-700"
                                                    />
                                                </a>
                                            </li>

                                            <li className="bg-[#e6e6e6cf] h-10 w-10 rounded-full flex items-center justify-center shrink-0">
                                                <a
                                                    href="https://www.instagram.com/easy.link.24/profilecard/?igsh=NTQxcTA2NWd3Z2h6"
                                                    target="_blank"
                                                >
                                                    <Instagram
                                                        size={24}
                                                        className="text-blue-700"
                                                    />
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div
                                    id="docs-card"
                                    className="flex flex-col items-start gap-6 overflow-hidden rounded-lg bg-white p-6 shadow-[0px_14px_34px_0px_rgba(0,0,0,0.08)] ring-1 ring-white/[0.05] transition duration-300 hover:text-black/70 hover:ring-black/20 focus:outline-none focus-visible:ring-[#FF2D20] md:row-span-3 lg:p-10 lg:pb-10 dark:bg-zinc-900 dark:ring-zinc-800 dark:hover:text-white/70 dark:hover:ring-zinc-700 dark:focus-visible:ring-[#FF2D20]"
                                >
                                    <div className="relative flex items-center gap-6 lg:items-end">
                                        <div
                                            id="docs-card-content"
                                            className="flex items-start gap-6 lg:flex-col"
                                        >
                                            <div className="pt-3 sm:pt-5 lg:pt-0">
                                                {flash?.success && (
                                                    <div className="flex justify-center items-center -mt-5 mb-[-10px]">
                                                        <div
                                                            id="toast-success"
                                                            className="flex items-center w-full max-w-xs p-2 mb-4 text-green-500 bg-green-100 rounded-lg shadow dark:text-gray-400 dark:bg-gray-800"
                                                            role="alert"
                                                        >
                                                            <div className="inline-flex items-center justify-center flex-shrink-0 w-8 h-8 text-green-500 bg-green-100 rounded-lg dark:bg-green-800 dark:text-green-200">
                                                                <svg
                                                                    className="w-5 h-5"
                                                                    aria-hidden="true"
                                                                    xmlns="http://www.w3.org/2000/svg"
                                                                    fill="currentColor"
                                                                    viewBox="0 0 20 20"
                                                                >
                                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z" />
                                                                </svg>
                                                                <span className="sr-only">
                                                                    Check icon
                                                                </span>
                                                            </div>
                                                            <div className="ms-3 text-sm font-normal">
                                                                {flash.success}
                                                            </div>
                                                        </div>
                                                    </div>
                                                )}
                                                <h2 className="text-xl font-semibold text-black dark:text-white">
                                                    Contact Form
                                                </h2>
                                                <form
                                                    onSubmit={handleSubmit}
                                                    className="ml-auto space-y-4 mt-3"
                                                >
                                                    <input
                                                        value={data.name}
                                                        onChange={(e) =>
                                                            setData(
                                                                "name",
                                                                e.target.value
                                                            )
                                                        }
                                                        type="text"
                                                        placeholder="Full Name"
                                                        className="w-full rounded-md py-3 px-4 bg-gray-100 text-gray-800 text-sm outline-blue-500 focus:bg-transparent"
                                                        required
                                                    />
                                                    {errors.name && (
                                                        <p className="text-red-600 text-xs">
                                                            {errors.name}
                                                        </p>
                                                    )}

                                                    <input
                                                        value={data.email}
                                                        onChange={(e) =>
                                                            setData(
                                                                "email",
                                                                e.target.value
                                                            )
                                                        }
                                                        type="email"
                                                        placeholder="Email Address"
                                                        className="w-full rounded-md py-3 px-4 bg-gray-100 text-gray-800 text-sm outline-blue-500 focus:bg-transparent"
                                                        required
                                                    />
                                                    {errors.email && (
                                                        <p className="text-red-600 text-xs">
                                                            {errors.email}
                                                        </p>
                                                    )}
                                                    <input
                                                        value={data.subject}
                                                        onChange={(e) =>
                                                            setData(
                                                                "subject",
                                                                e.target.value
                                                            )
                                                        }
                                                        type="text"
                                                        placeholder="Subject"
                                                        className="w-full rounded-md py-3 px-4 bg-gray-100 text-gray-800 text-sm outline-blue-500 focus:bg-transparent"
                                                        required
                                                    />
                                                    {errors.subject && (
                                                        <p className="text-red-600 text-xs">
                                                            {errors.subject}
                                                        </p>
                                                    )}
                                                    <textarea
                                                        value={data.message}
                                                        onChange={(e) =>
                                                            setData(
                                                                "message",
                                                                e.target.value
                                                            )
                                                        }
                                                        placeholder="Message"
                                                        rows={6}
                                                        className="w-full rounded-md px-4 bg-gray-100 text-gray-800 text-sm pt-3 outline-blue-500 focus:bg-transparent"
                                                        required
                                                    ></textarea>
                                                    {errors.message && (
                                                        <p className="text-red-600 text-xs">
                                                            {errors.message}
                                                        </p>
                                                    )}
                                                    <button
                                                        type="submit"
                                                        className={`${
                                                            !processing
                                                                ? "text-white bg-blue-700 hover:bg-blue-700 tracking-wide rounded-md text-md font-semibold px-4 py-3 w-full !mt-6"
                                                                : "bg-blue-600 text-white cursor-not-allowed tracking-wide rounded-md text-md font-semibold px-4 py-3 w-full !mt-6"
                                                        }`}
                                                        disabled={processing}
                                                    >
                                                        {processing ? (
                                                            <div className="flex justify-center items-center gap-1">
                                                                Sending
                                                                <svg
                                                                    xmlns="http://www.w3.org/2000/svg"
                                                                    width="18px"
                                                                    fill="#fff"
                                                                    className="ml-2 inline animate-spin"
                                                                    viewBox="0 0 24 24"
                                                                >
                                                                    <path
                                                                        fill-rule="evenodd"
                                                                        d="M7.03 2.757a1 1 0 0 1 1.213-.727l4 1a1 1 0 0 1 .59 1.525l-2 3a1 1 0 0 1-1.665-1.11l.755-1.132a7.003 7.003 0 0 0-2.735 11.77 1 1 0 0 1-1.376 1.453A8.978 8.978 0 0 1 3 12a9 9 0 0 1 4.874-8l-.117-.03a1 1 0 0 1-.727-1.213zm10.092 3.017a1 1 0 0 1 1.414.038A8.973 8.973 0 0 1 21 12a9 9 0 0 1-5.068 8.098 1 1 0 0 1-.707 1.864l-3.5-1a1 1 0 0 1-.557-1.517l2-3a1 1 0 0 1 1.664 1.11l-.755 1.132a7.003 7.003 0 0 0 3.006-11.5 1 1 0 0 1 .039-1.413z"
                                                                        clip-rule="evenodd"
                                                                        data-original="#000000"
                                                                    />
                                                                </svg>
                                                            </div>
                                                        ) : (
                                                            <div className="flex justify-center items-center gap-1">
                                                                Send
                                                                <Send
                                                                    size={18}
                                                                />
                                                            </div>
                                                        )}
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </main>
                        <Footer />
                    </div>
                </div>
            </div>
        </>
    );
};

export default Create;
