import { TableCell } from "@/Components/ui/table";
import { DeleteLink } from "./DeleteLink";
import { Contact } from "@/types/custom";

const UserTableRow = ({ user }: { user: Contact }) => {
    return (
        <>
            <TableCell className="font-medium">{user.name}</TableCell>
            <TableCell>{user.email}</TableCell>
            <TableCell>{user.subject}</TableCell>
            <TableCell>{user.message}</TableCell>
            <TableCell>
                <DeleteLink id={user.id} />
            </TableCell>
        </>
    );
};

export default UserTableRow;
