import { Button } from "@/Components/ui/button";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { icons } from "@/lib/icons";
import { Head, Link } from "@inertiajs/react";
import { ArrowLeft } from "lucide-react";
import DialogForm from "./Partials/DialogForm";

export default function Create() {
    return (
        <AuthenticatedLayout>
            <Head title="Add Links" />

            <div className="py-12">
                <div className="max-w-full md:max-w-2xl mx-auto sm:px-6 lg:px-8">
                    <Link href={route("links")}>
                        <Button variant={"outline"}>
                            <ArrowLeft size={14} />
                            <span>Back</span>
                        </Button>
                    </Link>

                    <div className="bg-white overflow-hidden shadow-sm sm:rounded-lg mt-1">
                        <div className="p-6 text-gray-900 flex flex-col gap-3">
                            {icons.map((icon) => (
                                <div
                                    key={icon.id}
                                    className="bg-slate-100 p-4 rounded-lg"
                                >
                                    <div className="flex justify-between">
                                        <div className="flex justify-center items-center gap-4">
                                            <span>{icon.svg}</span>
                                            <p>
                                                {icon.title
                                                    .charAt(0)
                                                    .toUpperCase() +
                                                    icon.title.slice(1)}
                                            </p>
                                        </div>
                                        <DialogForm
                                            id={icon.id}
                                            title={icon.title}
                                            svg={icon.svg}
                                        />
                                    </div>
                                </div>
                            ))}
                        </div>
                    </div>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
