import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { Head, Link } from "@inertiajs/react";
import { PlusCircle, X } from "lucide-react";
import { url } from "@/lib/url";
import { DeleteLink } from "./Partials/DeleteLink";
import { Button } from "@/Components/ui/button";
import EditDialogForm from "./Partials/EditDialogForm";

type Media = {
    id: string,
    name: string,
    title: string,
    url: string,
    user_id: string,
}

export default function Index({ success, medias }: {success:string, medias: Media[] }) {
    return (
        <AuthenticatedLayout>
            <Head title="Links" />

            <div className="py-12">
                <div className="max-w-full md:max-w-3xl mx-auto sm:px-6 lg:px-8">
                    <Link href={route("links.create")}>
                        <Button variant={"outline"} className="flex gap-1">
                            <PlusCircle size={14} /> <p>Add New Link</p>
                        </Button>
                    </Link>

                    <div className="bg-white overflow-hidden shadow-sm sm:rounded-lg mt-1">
                        <div className="p-6 text-gray-900">
                            <div className="flex justify-between">
                                <h3>My Links</h3>
                                <p> ({medias.length} Links) </p>
                            </div>
                            <div className="flex flex-col gap-3 mt-3">
                                {medias.map((media: Media) => (
                                    <div
                                        key={media.id}
                                        className="bg-slate-100 p-4 rounded-lg"
                                    >
                                        <div className="flex justify-around">
                                            <div>
                                                <img
                                                    src={`${url}/storage/images/${media.name}.png`}
                                                    alt={media.name}
                                                />
                                            </div>
                                            <div>
                                                {media.title
                                                    .charAt(0)
                                                    .toUpperCase() +
                                                    media.title.slice(1)}
                                            </div>
                                            <div className="flex justify-center items-center gap-2">
                                               <>
                                               <DeleteLink id={media.id} />
                                                <EditDialogForm 
                                                    media={media}
                                                    svg={`${url}/storage/images/${media.name}.png`}
                                                    success={success}
                                                 />
                                               </>
                                            </div>
                                        </div>
                                    </div>
                                ))}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
