import { Button } from "@/Components/ui/button";
import {
    Dialog,
    DialogContent,
    DialogFooter,
    DialogHeader,
    DialogTitle,
    DialogTrigger,
} from "@/Components/ui/dialog";
import { Input } from "@/Components/ui/input";
import { PlusIcon } from "lucide-react";
import { useForm } from "@inertiajs/react";
import { Label } from "@/Components/ui/label";

export default function DialogForm({
    id,
    title,
    svg,
}: {
    id: number;
    title: string;
    svg: any;
}) {
    const { data, setData, post, processing, errors } = useForm({
        name: title,
        title: "",
        url: "",
    });

    const handleSubmit = (e: React.FormEvent) => {
        e.preventDefault();
        post(route("links.store"));
    };

    return (
        <Dialog>
            <DialogTrigger asChild>
                <Button variant={"outline"}>
                    <PlusIcon size={14} />
                    <span className="text-sm">Add</span>
                </Button>
            </DialogTrigger>

            <DialogContent className="sm:max-w-[480px]">
                <form onSubmit={handleSubmit}>
                    <DialogHeader>
                        <div className="flex flex-col gap-1 justify-center items-center">
                            <span>{svg}</span>
                            <DialogTitle>
                                {title.charAt(0).toUpperCase() + title.slice(1)}
                            </DialogTitle>
                        </div>
                    </DialogHeader>
                    <div className="grid gap-4 py-4">
                        <div className="grid grid-cols-4 items-center gap-4">
                            <Label htmlFor="title" className="text-right">
                                Link Title
                            </Label>
                            <Input
                                value={data.title}
                                onChange={(e) =>
                                    setData("title", e.target.value)
                                }
                                id="title"
                                placeholder={
                                    title.charAt(0).toUpperCase() +
                                    title.slice(1)
                                }
                                type="text"
                                className="col-span-3"
                            />
                        </div>
                        <div className="flex justify-center items-center mt-[-12px]">
                            {errors.title && (
                                <p className="text-red-600 text-xs">
                                    {errors.title}
                                </p>
                            )}
                        </div>
                        <div className="grid grid-cols-4 items-center gap-4">
                            <Label htmlFor="url" className="text-right">
                                {title.charAt(0).toUpperCase() + title.slice(1)}
                                Url
                            </Label>
                            <Input
                                value={data.url}
                                onChange={(e) => setData("url", e.target.value)}
                                id="url"
                                type="text"
                                placeholder={`${
                                    data.name == "whatsapp"
                                        ? "93771234567"
                                        : data.name == "whatsapp Business"
                                        ? "93771234567"
                                        : data.name == "telegram"
                                        ? "rahmat"
                                        : data.name == "messenger"
                                        ? "rahmat"
                                        : data.name == "gmail"
                                        ? "example@gmail.com"
                                        : `https://www.${title}.com/rahmat`
                                }`}
                                className="col-span-3"
                            />
                        </div>
                        <div className="flex justify-center items-center mt-[-12px]">
                            {errors.url && (
                                <p className="text-red-600 text-xs">
                                    {errors.url}
                                </p>
                            )}
                        </div>
                    </div>
                    <DialogFooter>
                        <Button type="submit" disabled={processing}>
                            {processing? "Adding...":"Add"}
                        </Button>
                    </DialogFooter>
                </form>
            </DialogContent>
        </Dialog>
    );
}
