import { Head } from "@inertiajs/react";
import { Avatar, AvatarFallback, AvatarImage } from "@/Components/ui/avatar";
import { Mail, Phone } from "lucide-react";
import {
    Tooltip,
    TooltipContent,
    TooltipProvider,
    TooltipTrigger,
} from "@/Components/ui/tooltip";
import { url } from "@/lib/url";
import { Button } from "@/Components/ui/button";
import { User } from "@/types";
import { Media } from "@/types/custom";
import { useState } from "react";

const Share = ({ user, medias }: { user: User; medias: Media[] }) => {
    const [isOpen, setIsOpen] = useState(false);
    const [isEmailOpen, setIsEmailOpen] = useState(false);

    const handlePhoneCall = (phone: string | undefined) => {
        window.open(`tel:${phone}`);
    };

    const handleEmail = (email: string | undefined) => {
        window.open(`mailto:${email}`);
    };

    return (
        <div>
            <Head title="Display Links " />

            <div className="py-3 bg-white min-h-screen -mt-6">
                <div className="max-w-full md:max-w-7xl mx-auto sm:px-6 lg:px-8">
                    <div className="p-6 text-gray-900 flex flex-col gap-5 justify-center items-center">
                        <div className="mb-[-18px]">
                            {user.cover ? (
                                <img
                                    src={`${url}/storage/uploads/${user.cover}`}
                                    alt="cover"
                                    className="w-80 h-52 rounded-3xl"
                                />
                            ) : (
                                <img
                                    src={`${url}/images/logo.jpg`}
                                    alt="cover"
                                    className="w-80 h-52 rounded-3xl shadow-md p-3"
                                />
                            )}

                            <div className="flex justify-center items-center mt-[-50px]">
                                <Avatar>
                                    {user.avatar ? (
                                        <AvatarImage
                                            src={`${url}/storage/uploads/${user.avatar}`}
                                        />
                                    ) : (
                                        <AvatarImage
                                            src={`${url}/images/avatar.png`}
                                        />
                                    )}
                                    <AvatarFallback>{user.name}</AvatarFallback>
                                </Avatar>
                            </div>
                        </div>
                        <p className="text-xl font-semibold">{user.name}</p>
                        <p className="flex justify-center items-center text-xs font-thin -mt-5">
                            {user.job} {user.company ? "@" : null}{" "}
                            {user.company}
                        </p>
                        <p className="flex justify-center items-center text-sm font-medium -mt-5 w-80">
                            {user.bio}
                        </p>
                        <p className="flex justify-center items-center text-sm font-medium -mt-5 w-80">
                            {user.address}
                        </p>
                        {(Boolean(user.media_active) ||
                            Boolean(user.product_active)) && (
                            <>
                                <div className="flex gap-5">
                                    <div>
                                        <TooltipProvider>
                                            <Tooltip open={isOpen}>
                                                <TooltipTrigger asChild>
                                                    {user.mobile ? (
                                                        <Button
                                                            variant="primary"
                                                            onClick={() =>
                                                                setIsOpen(
                                                                    !isOpen
                                                                )
                                                            }
                                                        >
                                                            <Phone />
                                                        </Button>
                                                    ) : (
                                                        <Button
                                                            variant="primary"
                                                            onClick={() =>
                                                                handlePhoneCall(
                                                                    user.phone
                                                                )
                                                            }
                                                        >
                                                            <Phone />
                                                        </Button>
                                                    )}
                                                </TooltipTrigger>
                                                <TooltipContent>
                                                    <div className="flex flex-col">
                                                        <p
                                                            onClick={() =>
                                                                handlePhoneCall(
                                                                    user.phone
                                                                )
                                                            }
                                                            className="text-lg font-semibold p-2 hover:cursor-pointer"
                                                        >
                                                            {user.phone}
                                                        </p>
                                                        <p
                                                            onClick={() =>
                                                                handlePhoneCall(
                                                                    user.mobile
                                                                )
                                                            }
                                                            className="text-lg font-semibold p-2 hover:cursor-pointer"
                                                        >
                                                            {user.mobile}
                                                        </p>
                                                    </div>
                                                </TooltipContent>
                                            </Tooltip>
                                        </TooltipProvider>
                                    </div>

                                    <div>
                                        <TooltipProvider>
                                            <Tooltip open={isEmailOpen}>
                                                <TooltipTrigger asChild>
                                                    {user.mail ? (
                                                        <Button
                                                            variant="primary"
                                                            onClick={() =>
                                                                setIsEmailOpen(
                                                                    !isEmailOpen
                                                                )
                                                            }
                                                        >
                                                            <Mail />
                                                        </Button>
                                                    ) : (
                                                        <Button
                                                            variant="primary"
                                                            onClick={() =>
                                                                handleEmail(
                                                                    user.email
                                                                )
                                                            }
                                                        >
                                                            <Mail />
                                                        </Button>
                                                    )}
                                                </TooltipTrigger>
                                                <TooltipContent>
                                                    <div className="flex flex-col">
                                                        <p
                                                            onClick={() =>
                                                                handleEmail(
                                                                    user.email
                                                                )
                                                            }
                                                            className="text-lg font-semibold p-2 hover:cursor-pointer"
                                                        >
                                                            {user.email}
                                                        </p>
                                                        <p
                                                            onClick={() =>
                                                                handleEmail(
                                                                    user.mail
                                                                )
                                                            }
                                                            className="text-lg font-semibold p-2 hover:cursor-pointer"
                                                        >
                                                            {user.mail}
                                                        </p>
                                                    </div>
                                                </TooltipContent>
                                            </Tooltip>
                                        </TooltipProvider>
                                    </div>
                                </div>

                                <div>
                                    <a
                                        href={route("vcard", user.id)}
                                        target="_blank"
                                    >
                                        <Button
                                            className="w-[140px] text-md font-semibold"
                                            variant={"default"}
                                        >
                                            Save Contact
                                        </Button>
                                    </a>
                                </div>
                            </>
                        )}
                        <div className="bg-gray-100 shadow-md max-w-full md:max-w-7xl mx-auto rounded-lg">
                            {user.store && Boolean(user.product_active) && (
                                <a
                                    href={route(
                                        "store.display.index",
                                        user.store.id
                                    )}
                                    target="_blank"
                                    className="flex flex-col justify-center items-center p-5 -mb-10"
                                >
                                    <div>
                                        {user.store.logo ? (
                                        <img
                                            src={`${url}/storage/store/${user.store.logo}`}
                                            className="w-12 h-12 md:w-16 md:h-16 bg-white p-1 rounded-full"
                                            alt={user.store.name}
                                        />
                                        ):(
                                        <img
                                            src={`${url}/images/logo.jpg`}
                                            className="w-12 h-12 md:w-16 md:h-16 bg-white p-1 rounded-full"
                                            alt={user.store.name}
                                        />
                                        )}
                                    </div>
                                    <p className="text-sm font-bold text-yellow-900">
                                        {user.store.name}
                                    </p>
                                </a>
                            )}
                            {medias.length > 0 &&
                                Boolean(user.media_active) && (
                                    <div className="grid grid-cols-3 p-5">
                                        {medias
                                            .filter(
                                                (media) =>
                                                    media.name !== "gmail"
                                            )
                                            .map((media: Media) => (
                                                <a
                                                    href={media.url}
                                                    target="_blank"
                                                    key={media.id}
                                                    className="flex flex-col justify-center items-center p-5"
                                                >
                                                    <div>
                                                        <img
                                                            src={`${url}/storage/images/${media.name}.png`}
                                                            className="w-12 h-12 md:w-16 md:h-16 bg-white p-1 rounded-full"
                                                            alt={media.name}
                                                        />
                                                    </div>
                                                    <p className="text-sm font-bold text-yellow-900">
                                                        {media.title
                                                            .charAt(0)
                                                            .toUpperCase() +
                                                            media.title.slice(
                                                                1
                                                            )}
                                                    </p>
                                                </a>
                                            ))}
                                        {medias
                                            .filter(
                                                (media) =>
                                                    media.name === "gmail"
                                            )
                                            .map((media: Media) => (
                                                <a
                                                    href="#"
                                                    key={media.id}
                                                    className="flex flex-col justify-center items-center p-5"
                                                    onClick={() =>
                                                        handleEmail(media.url)
                                                    }
                                                >
                                                    <div>
                                                        <img
                                                            src={`${url}/storage/images/${media.name}.png`}
                                                            className="w-12 h-12 md:w-16 md:h-16 bg-white p-1 rounded-full"
                                                            alt={media.name}
                                                        />
                                                    </div>
                                                    <p className="text-sm font-bold text-yellow-900">
                                                        {media.title
                                                            .charAt(0)
                                                            .toUpperCase() +
                                                            media.title.slice(
                                                                1
                                                            )}
                                                    </p>
                                                </a>
                                            ))}
                                    </div>
                                )}
                            {(medias.length <= 0 && !user.store) ||
                            (!Boolean(user.media_active) &&
                                !Boolean(user.product_active)) ? (
                                <div className="text-center py-4 px-20">
                                    <h1 className="mb-4 text-3xl font-semibold text-red-500">
                                        Oops!
                                    </h1>
                                    <p className="mb-4 text-md text-yellow-600">
                                        Looks like there is no links avaliable.
                                    </p>
                                    <div className="animate-bounce">
                                        <svg
                                            className="mx-auto h-16 w-16 text-red-500"
                                            fill="none"
                                            viewBox="0 0 24 24"
                                            stroke="currentColor"
                                        >
                                            <path
                                                strokeLinecap="round"
                                                strokeLinejoin="round"
                                                strokeWidth="2"
                                                d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"
                                            ></path>
                                        </svg>
                                    </div>
                                    <p className="mt-4 text-sm text-yellow-600">
                                        Let's get you back
                                        <a
                                            href="/"
                                            className="ml-1 font-semibold underline"
                                        >
                                            Home
                                        </a>
                                        .
                                    </p>
                                </div>
                            ) : null}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    );
};

export default Share;
