import { Button } from "@/Components/ui/button";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { User } from "@/types";
import { Head, Link, useForm } from "@inertiajs/react";
import {
    ArrowLeft,
    FilterXIcon,
    PlusCircle,
    User as UserIcon,
} from "lucide-react";
import {
    Table,
    TableBody,
    TableCaption,
    TableHead,
    TableHeader,
    TableRow,
} from "@/Components/ui/table";
import ProductTableRow from "./Partials/ProductTableRow";
import TextInput from "@/Components/TextInput";
import Pagination from "@/Components/Pagination";
import { Product } from "@/types/custom";

export default function Index({
    products,
    user,
}: {
    products: Product;
    user: User;
}) {
    const { data, setData, get, processing } = useForm({
        search: "",
    });
    const handleSearch = (e: React.FormEvent) => {
        e.preventDefault();
        //@ts-ignore
        get(route("admin.products.index", user.id), { data });
    };

    return (
        <AuthenticatedLayout>
            <Head title="Products" />

            <div className="py-12">
                <div className="max-w-full md:max-w-7xl mx-auto sm:px-6 lg:px-8">
                    <div className="flex flex-col sm:flex-row justify-between items-center">
                        <Link href={route("user.store.index", user.id)}>
                            <Button variant={"outline"} className="flex gap-1">
                                <ArrowLeft size={14} />
                                <p>Back</p>
                            </Button>
                        </Link>
                        <Link href={route("admin.products.create", user.id)}>
                            <Button variant={"outline"} className="flex gap-1">
                                <PlusCircle size={14} />
                                <p>Add New Product</p>
                            </Button>
                        </Link>
                        <p className="flex justify-center items-center">
                            <UserIcon size={18} /> {user.name}
                        </p>
                        <div className="flex gap-2">
                            <Link
                                href={route("admin.products.index", user.id)}
                                className="flex justify-center items-center"
                            >
                                <FilterXIcon size={24} color="black" />
                            </Link>
                            <form onSubmit={handleSearch}>
                                <TextInput
                                    value={data.search}
                                    onChange={(e) =>
                                        setData({ search: e.target.value })
                                    }
                                    placeholder="Search product name..."
                                    className="text-sm w-[250px] mr-1"
                                    required
                                />
                                <Button type="submit" disabled={processing}>
                                    {processing ? "Search..." : "Search"}
                                </Button>
                            </form>
                        </div>
                    </div>
                    <div className="bg-white overflow-hidden shadow-sm sm:rounded-lg mt-1">
                        <div className="p-6 text-gray-900">
                            <Table>
                                <TableCaption>List of products.</TableCaption>
                                <TableHeader>
                                    <TableRow>
                                        <TableHead className="w-[150px]">
                                            Image
                                        </TableHead>
                                        <TableHead className="w-[100px]">
                                            Name
                                        </TableHead>
                                        <TableHead>Description</TableHead>
                                        <TableHead className="w-[100px]">
                                            Price
                                        </TableHead>
                                        <TableHead className="w-[100px]">
                                            Category
                                        </TableHead>
                                        <TableHead className="flex justify-end items-center">
                                            Action
                                        </TableHead>
                                    </TableRow>
                                </TableHeader>
                                <TableBody>
                                    {
                                        //@ts-ignore
                                        products.data.map(
                                            (product: Product) => (
                                                <TableRow key={product.id}>
                                                    <ProductTableRow
                                                        product={product}
                                                        userId={user.id}
                                                    />
                                                </TableRow>
                                            )
                                        )
                                    }
                                </TableBody>
                            </Table>
                            <Pagination
                                //@ts-ignore
                                links={products.links}
                            />
                        </div>
                    </div>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
