import { Button } from "@/Components/ui/button";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { User } from "@/types";
import { Head, Link, useForm } from "@inertiajs/react";
import { FilterXIcon } from "lucide-react";
import {
    Table,
    TableBody,
    TableCaption,
    TableCell,
    TableHead,
    TableHeader,
    TableRow,
} from "@/Components/ui/table";
import TextInput from "@/Components/TextInput";
import Pagination from "@/Components/Pagination";
import { Product } from "@/types/custom";
import ImageGallery from "./Partials/ImageGallery";

export default function ProductLists({ products }: { products: Product }) {
    const { data, setData, get, processing } = useForm({
        search: "",
    });
    const handleSearch = (e: React.FormEvent) => {
        e.preventDefault();
        //@ts-ignore
        get(route("admin.products.all"), { data });
    };

    return (
        <AuthenticatedLayout>
            <Head title="Products" />

            <div className="py-12">
                <div className="max-w-full md:max-w-7xl mx-auto sm:px-6 lg:px-8">
                    <div className="flex flex-col sm:flex-row justify-between items-center">
                        <p className="flex justify-center items-center">
                            All Products
                        </p>
                        <div className="flex gap-2">
                            <Link
                                href={route("admin.products.all")}
                                className="flex justify-center items-center"
                            >
                                <FilterXIcon size={24} color="black" />
                            </Link>
                            <form onSubmit={handleSearch}>
                                <TextInput
                                    value={data.search}
                                    onChange={(e) =>
                                        setData({ search: e.target.value })
                                    }
                                    placeholder="Search name, price, category..."
                                    className="text-sm w-[250px] mr-1"
                                    required
                                />
                                <Button type="submit" disabled={processing}>
                                    {processing ? (
                                        <>
                                            Search
                                            <svg
                                                xmlns="http://www.w3.org/2000/svg"
                                                width="18px"
                                                fill="#fff"
                                                className="ml-2 inline animate-spin"
                                                viewBox="0 0 24 24"
                                            >
                                                <path
                                                    fill-rule="evenodd"
                                                    d="M7.03 2.757a1 1 0 0 1 1.213-.727l4 1a1 1 0 0 1 .59 1.525l-2 3a1 1 0 0 1-1.665-1.11l.755-1.132a7.003 7.003 0 0 0-2.735 11.77 1 1 0 0 1-1.376 1.453A8.978 8.978 0 0 1 3 12a9 9 0 0 1 4.874-8l-.117-.03a1 1 0 0 1-.727-1.213zm10.092 3.017a1 1 0 0 1 1.414.038A8.973 8.973 0 0 1 21 12a9 9 0 0 1-5.068 8.098 1 1 0 0 1-.707 1.864l-3.5-1a1 1 0 0 1-.557-1.517l2-3a1 1 0 0 1 1.664 1.11l-.755 1.132a7.003 7.003 0 0 0 3.006-11.5 1 1 0 0 1 .039-1.413z"
                                                    clip-rule="evenodd"
                                                    data-original="#000000"
                                                />
                                            </svg>
                                        </>
                                    ) : (
                                        "Search"
                                    )}
                                </Button>
                            </form>
                        </div>
                    </div>
                    <div className="bg-white overflow-hidden shadow-sm sm:rounded-lg mt-1">
                        <div className="p-6 text-gray-900">
                            <Table>
                                <TableCaption>List of products.</TableCaption>
                                <TableHeader>
                                    <TableRow>
                                        <TableHead className="w-[150px]">
                                            Image
                                        </TableHead>
                                        <TableHead className="w-[100px]">
                                            Name
                                        </TableHead>
                                        <TableHead>Description</TableHead>
                                        <TableHead className="w-[100px]">
                                            Price
                                        </TableHead>
                                        <TableHead className="w-[100px]">
                                            Category
                                        </TableHead>
                                        <TableHead className="w-[100px]">
                                            Store
                                        </TableHead>
                                        <TableHead className="w-[100px]">
                                            User
                                        </TableHead>
                                    </TableRow>
                                </TableHeader>
                                <TableBody>
                                    {
                                        //@ts-ignore
                                        products.data.map(
                                            (product: Product) => (
                                                <TableRow key={product.id}>
                                                    <TableCell>
                                                        <ImageGallery
                                                            images={
                                                                product.images
                                                            }
                                                        />
                                                    </TableCell>
                                                    <TableCell className="font-medium">
                                                        {product.name}
                                                    </TableCell>
                                                    <TableCell>
                                                        {product.description}
                                                    </TableCell>
                                                    <TableCell>
                                                        {product.price > 0
                                                            ? `${product.price} AF`
                                                            : null}
                                                    </TableCell>
                                                    <TableCell>
                                                        {product.category?.name}
                                                    </TableCell>
                                                    <TableCell>
                                                        {product.store?.name}
                                                    </TableCell>
                                                    <TableCell>
                                                        {
                                                            product.store?.user
                                                                ?.name
                                                        }
                                                    </TableCell>
                                                </TableRow>
                                            )
                                        )
                                    }
                                </TableBody>
                            </Table>
                            <Pagination
                                //@ts-ignore
                                links={products.links}
                            />
                        </div>
                    </div>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
