import { Button } from "@/Components/ui/button";
import { Head, Link, useForm } from "@inertiajs/react";
import { Eye, FilterXIcon, SearchIcon, Tag } from "lucide-react";
import TextInput from "@/Components/TextInput";
import Pagination from "@/Components/Pagination";
import { Product, Store } from "@/types/custom";
import { url } from "@/lib/url";
import NotFound from "@/Components/NotFound";
import ClientHeader from "@/Components/ClientHeader";
import ClientFooter from "@/Components/ClientFooter";

export default function Index({
    products,
    store,
}: {
    products: Product;
    store: Store;
}) {
    const { data, setData, get, processing } = useForm({
        search: "",
    });
    const handleSearch = (e: React.FormEvent) => {
        e.preventDefault();
        //@ts-ignore
        get(route("store.display.index", store.id), { data });
    };

    return (
        <>
            <ClientHeader store={store} />
            <Head title="Products" />

            <div className="p-4 bg-gray-100 min-h-screen">
                <div className="max-w-full md:max-w-7xl mx-auto sm:px-6 lg:px-8">
                    <div className="flex flex-col sm:flex-row justify-between items-center">
                        <div className="flex gap-2 p-4 ">
                            <Link
                                href={route("store.display.index", store.id)}
                                className="flex justify-center items-center"
                            >
                                <FilterXIcon size={24} color="black" />
                            </Link>
                            <form
                                onSubmit={handleSearch}
                                className="flex justify-center items-center"
                            >
                                <TextInput
                                    value={data.search}
                                    onChange={(e) =>
                                        setData({ search: e.target.value })
                                    }
                                    placeholder="Search name,price or category ..."
                                    className="text-sm w-[250px] mr-1"
                                    required
                                />
                                <Button type="submit" disabled={processing}>
                                    {processing ? (
                                        <svg
                                            xmlns="http://www.w3.org/2000/svg"
                                            width="18px"
                                            fill="#fff"
                                            className="ml-2 inline animate-spin"
                                            viewBox="0 0 24 24"
                                        >
                                            <path
                                                fill-rule="evenodd"
                                                d="M7.03 2.757a1 1 0 0 1 1.213-.727l4 1a1 1 0 0 1 .59 1.525l-2 3a1 1 0 0 1-1.665-1.11l.755-1.132a7.003 7.003 0 0 0-2.735 11.77 1 1 0 0 1-1.376 1.453A8.978 8.978 0 0 1 3 12a9 9 0 0 1 4.874-8l-.117-.03a1 1 0 0 1-.727-1.213zm10.092 3.017a1 1 0 0 1 1.414.038A8.973 8.973 0 0 1 21 12a9 9 0 0 1-5.068 8.098 1 1 0 0 1-.707 1.864l-3.5-1a1 1 0 0 1-.557-1.517l2-3a1 1 0 0 1 1.664 1.11l-.755 1.132a7.003 7.003 0 0 0 3.006-11.5 1 1 0 0 1 .039-1.413z"
                                                clip-rule="evenodd"
                                                data-original="#000000"
                                            />
                                        </svg>
                                    ) : (
                                        <SearchIcon size={18} />
                                    )}
                                </Button>
                            </form>
                        </div>
                    </div>
                    {
                        //@ts-ignore
                        products.data.length === 0 && (
                            <div className="-mt-20">
                                <NotFound id={store.id} />
                            </div>
                        )
                    }
                    <div className="font-sans p-4 mx-auto lg:max-w-6xl md:max-w-3xl sm:max-w-full mt-1">
                        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                            {
                                //@ts-ignore
                                products.data.length > 0 &&
                                    //@ts-ignore
                                    products.data.map((product: Product) => (
                                        <Link
                                            key={product.id}
                                            href={`/shop/${store.id}/${product.id}`}
                                            className="bg-white rounded-md overflow-hidden shadow-md cursor-pointer hover:scale-[1.02] transition-all"
                                        >
                                            <div className="w-full aspect-w-16 aspect-h-8 lg:h-60">
                                                <img
                                                    src={`${url}/storage/products/${product.images[0]}`}
                                                    alt={product.name}
                                                    className="h-full w-full object-cover object-top  hover:opacity-75"
                                                />
                                            </div>

                                            <div className="p-4">
                                                <h3 className="text-lg font-bold text-gray-800">
                                                    {product.name}
                                                </h3>
                                                {product.category?.name ? (
                                                    <p className="text-sm flex justify-start items-center text-sky-600">
                                                        <Tag size={12} className="mr-1" />
                                                        {product.category?.name}
                                                    </p>
                                                ) : null}

                                                <div className="mt-4 flex items-center flex-wrap  justify-between gap-2">
                                                    {product.price ? (
                                                        <h4 className="text-sm font-semibold text-indigo-700 hover:scale-110 transition-all">
                                                            {product?.price} AF
                                                        </h4>
                                                    ) : (
                                                        <span></span>
                                                    )}
                                                    <Button
                                                        variant={"outline"}
                                                        className="bg-indigo-700 hover:bg-indigo-600 hover:scale-110 transition-all"
                                                    >
                                                        <Eye className="text-white" />
                                                    </Button>
                                                </div>
                                            </div>
                                        </Link>
                                    ))
                            }
                        </div>
                    </div>
                    <Pagination
                        //@ts-ignore
                        links={products.links}
                    />
                </div>
            </div>

            <ClientFooter store={store} />
        </>
    );
}
