import ClientFooter from "@/Components/ClientFooter";
import ClientHeader from "@/Components/ClientHeader";
import ImageSlider from "@/Components/ImageSlider";
import { Product, Store } from "@/types/custom";
import { Head, Link } from "@inertiajs/react";
import { ArrowLeft, Tag } from "lucide-react";

export default function Show({
    store,
    product,
}: {
    store: Store;
    product: Product;
}) {
    return (
        <>
            <ClientHeader store={store} />
            <Head title={product.name} />
            <div className="p-4 bg-gray-100 min-h-screen">
                <Link href={route("store.display.index", store.id)}>
                    <ArrowLeft />
                </Link>
                <div className="mx-auto max-w-2xl px-4 pb-16 pt-10 sm:px-6 lg:grid lg:max-w-7xl lg:grid-cols-3 lg:grid-rows-[auto,auto,1fr] lg:gap-x-8 lg:px-8 lg:pb-24 lg:pt-16">
                    <div className="lg:col-span-2 lg:border-r lg:border-gray-200 lg:pr-8">
                        <h1 className="text-2xl font-bold tracking-tight text-gray-900 sm:text-3xl mb-5">
                            {product.name}
                        </h1>
                        <ImageSlider images={product.images} />
                    </div>

                    <div className="mt-4 lg:row-span-3 lg:mt-0">
                        <h2 className="sr-only">Product information</h2>
                        {product.category?.name &&(
                            <p className="flex justify-start items-center">
                                <Tag size={14} /> &nbsp; {product.category?.name}
                             </p>
                        )}
                        {product.price ? (
                            <p className="text-3xl tracking-tight text-gray-900">
                                AF {product.price}
                            </p>
                        ):null}

                        <div className="py-10 lg:col-span-2 lg:col-start-1 lg:border-r lg:border-gray-200 lg:pb-16 lg:pr-8 lg:pt-6">
                            <div className="mt-7">
                                <div className="mt-4 space-y-6">
                                    <p className="text-sm text-gray-600">
                                        {product.description}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <ClientFooter store={store} />
        </>
    );
}
