//@ts-nocheck
import { Trash2 } from "lucide-react";
import React, { useState } from "react";
import { useDropzone } from "react-dropzone";

const FileDropzone = ({ files, setFiles }) => {
    const onDrop = (acceptedFiles) => {
        const newFiles = acceptedFiles.map((file) => ({
            file,
            preview: URL.createObjectURL(file),
        }));
        setFiles((prevFiles) => [...prevFiles, ...newFiles]);
    };

    const handleDelete = (fileToDelete) => {
        setFiles((prevFiles) =>
            prevFiles.filter(({ file }) => file !== fileToDelete)
        );
    };

    const { getRootProps, getInputProps, isDragActive } = useDropzone({
        onDrop,
    });

    return (
        <div className="flex flex-col items-center">
            <div
                {...getRootProps()}
                className={`border-2 border-dashed rounded-lg p-6 text-center transition-colors duration-200 
                    ${
                        isDragActive
                            ? "border-blue-500 bg-blue-100"
                            : "border-gray-300"
                    }`}
            >
                <div className="flex justify-center items-center">
                    <svg
                        xmlns="http://www.w3.org/2000/svg"
                        className="w-11 mb-2 fill-gray-500"
                        viewBox="0 0 32 32"
                    >
                        <path
                            d="M23.75 11.044a7.99 7.99 0 0 0-15.5-.009A8 8 0 0 0 9 27h3a1 1 0 0 0 0-2H9a6 6 0 0 1-.035-12 1.038 1.038 0 0 0 1.1-.854 5.991 5.991 0 0 1 11.862 0A1.08 1.08 0 0 0 23 13a6 6 0 0 1 0 12h-3a1 1 0 0 0 0 2h3a8 8 0 0 0 .75-15.956z"
                            data-original="#000000"
                        />
                        <path
                            d="M20.293 19.707a1 1 0 0 0 1.414-1.414l-5-5a1 1 0 0 0-1.414 0l-5 5a1 1 0 0 0 1.414 1.414L15 16.414V29a1 1 0 0 0 2 0V16.414z"
                            data-original="#000000"
                        />
                    </svg>
                </div>

                <input {...getInputProps()} accept="image/*" />
                {isDragActive ? (
                    <p className="text-blue-600">Drop the images here ...</p>
                ) : (
                    <p className="text-gray-600">
                        Drag 'n' drop some images here, or click to select files
                    </p>
                )}
            </div>

            <div className="mt-4">
                <ul className="mt-2">
                    {files.map(({ file, preview }) => (
                        <li
                            key={file.name}
                            className="flex items-center justify-between border-b py-2"
                        >
                            <div className="flex items-center">
                                <img
                                    src={preview}
                                    alt={file.name}
                                    className="w-10 h-10 object-cover mr-2"
                                />
                                <span className="text-gray-800 text-xs">
                                    {file.name}
                                </span>
                            </div>
                            <button
                                onClick={() => handleDelete(file)}
                                className="text-red-500 hover:text-red-700 hover:scale-110 p-2"
                            >
                                <Trash2 size={18} />
                            </button>
                        </li>
                    ))}
                </ul>
            </div>
        </div>
    );
};

export default FileDropzone;
