import { Button } from "@/Components/ui/button";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { Head, Link, useForm } from "@inertiajs/react";
import { FilterXIcon, PlusCircle } from "lucide-react";
import {
    Table,
    TableBody,
    TableCaption,
    TableHead,
    TableHeader,
    TableRow,
} from "@/Components/ui/table";
import ProductTableRow from "./Partials/ProductTableRow";
import TextInput from "@/Components/TextInput";
import Pagination from "@/Components/Pagination";
import { Product } from "@/types/custom";

export default function Index({ products }: { products: Product }) {
    const { data, setData, get, processing } = useForm({
        search: "",
    });
    const handleSearch = (e: React.FormEvent) => {
        e.preventDefault();
        //@ts-ignore
        get(route("products.index"), { data });
    };

    return (
        <AuthenticatedLayout>
            <Head title="Products" />

            <div className="py-12">
                <div className="max-w-full md:max-w-7xl mx-auto sm:px-6 lg:px-8">
                    <div className="flex flex-col sm:flex-row justify-between items-center">
                        <Link href={route("products.create")}>
                            <Button variant={"outline"} className="flex gap-1">
                                <PlusCircle size={14} />
                                <p>Add New Product</p>
                            </Button>
                        </Link>
                        <div className="flex gap-2">
                            <Link
                                href={route("products.index")}
                                className="flex justify-center items-center"
                            >
                                <FilterXIcon size={24} color="black" />
                            </Link>
                            <form onSubmit={handleSearch}>
                                <TextInput
                                    value={data.search}
                                    onChange={(e) =>
                                        setData({ search: e.target.value })
                                    }
                                    placeholder="Search product name or category..."
                                    className="text-sm w-[250px] mr-1"
                                    required
                                />
                                <Button type="submit" disabled={processing}>
                                    {processing ? "Search..." : "Search"}
                                </Button>
                            </form>
                        </div>
                    </div>
                    <div className="bg-white overflow-hidden shadow-sm sm:rounded-lg mt-1">
                        <div className="p-6 text-gray-900">
                            <Table>
                                <TableCaption>List of products.</TableCaption>
                                <TableHeader>
                                    <TableRow>
                                        <TableHead className="w-[150px]">
                                            Image
                                        </TableHead>
                                        <TableHead className="w-[100px]">
                                            Name
                                        </TableHead>
                                        <TableHead>Description</TableHead>
                                        <TableHead className="w-[100px]">
                                            Price
                                        </TableHead>
                                        <TableHead className="w-[100px]">
                                            Category
                                        </TableHead>
                                        <TableHead className="flex justify-end items-center">
                                            Action
                                        </TableHead>
                                    </TableRow>
                                </TableHeader>
                                <TableBody>
                                    {
                                        //@ts-ignore
                                        products.data.map(
                                            (product: Product) => (
                                                <TableRow key={product.id}>
                                                    <ProductTableRow
                                                        product={product}
                                                    />
                                                </TableRow>
                                            )
                                        )
                                    }
                                </TableBody>
                            </Table>
                            <Pagination
                                //@ts-ignore
                                links={products.links}
                            />
                        </div>
                    </div>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
