import InputLabel from "@/Components/InputLabel";
import PrimaryButton from "@/Components/PrimaryButton";
import { router, usePage } from "@inertiajs/react";
import { FormEventHandler, useState } from "react";
import { url } from "@/lib/url";
import { openEditor } from "react-profile";
import "react-profile/themes/default.min.css";

export default function UpdateAvatarForm({
    className = "",
}: {
    image?: string;
    className?: string;
}) {
    const user = usePage().props.auth.user;
    const [avatar, setAvatar] = useState(null);
    const [cover, setCover] = useState<File | null>(null);

    const handleAvatarChange = async (
        e: React.ChangeEvent<HTMLInputElement>
    ) => {
        if (
            //@ts-ignore
            e.target.files[0].type === "image/jpeg" ||
            //@ts-ignore
            e.target.files[0].type === "image/png"
        ) {
            //@ts-ignore
            const image = await openEditor({ src: e.target.files[0] });
            //@ts-ignore
            setAvatar(image?.editedImage?.getDataURL());
        } else {
            console.log("inValid type");
        }
    };

    const handleCoverChange = async (
        e: React.ChangeEvent<HTMLInputElement>
    ) => {
        if (
            //@ts-ignore
            e.target.files[0].type === "image/jpeg" ||
            //@ts-ignore
            e.target.files[0].type === "image/png"
        ) {
            //@ts-ignore
            const image = await openEditor({ src: e.target.files[0] });
            //@ts-ignore
            setCover(image?.editedImage?.getDataURL());
        } else {
            console.log("invalid type");
        }
    };

    const submit: FormEventHandler = (e) => {
        e.preventDefault();
        if (avatar || cover) {
            router.post(route("profile.file", user.id), {
                avatar: avatar,
                cover: cover as any,
            });
        }
    };

    return (
        <section className={className}>
            <header>
                <h2 className="text-lg font-medium text-gray-900">
                    Profile images
                </h2>

                <p className="mt-1 text-sm text-gray-600">
                    Update your account's profile and background pictures.
                </p>
            </header>

            <div>
                <form onSubmit={submit} className="mt-6 space-y-6">
                    <div className="flex justify-start items-center gap-3">
                        <div>
                            <label
                                htmlFor="avatar"
                                className="bg-white text-gray-500 font-semibold rounded max-w-md h-32 flex flex-col items-center justify-center cursor-pointer border-2 border-gray-300 border-dashed mx-auto font-[sans-serif] text-xs"
                            >
                                <svg
                                    xmlns="http://www.w3.org/2000/svg"
                                    className="w-11 mb-2 fill-gray-500"
                                    viewBox="0 0 32 32"
                                >
                                    <path
                                        d="M23.75 11.044a7.99 7.99 0 0 0-15.5-.009A8 8 0 0 0 9 27h3a1 1 0 0 0 0-2H9a6 6 0 0 1-.035-12 1.038 1.038 0 0 0 1.1-.854 5.991 5.991 0 0 1 11.862 0A1.08 1.08 0 0 0 23 13a6 6 0 0 1 0 12h-3a1 1 0 0 0 0 2h3a8 8 0 0 0 .75-15.956z"
                                        data-original="#000000"
                                    />
                                    <path
                                        d="M20.293 19.707a1 1 0 0 0 1.414-1.414l-5-5a1 1 0 0 0-1.414 0l-5 5a1 1 0 0 0 1.414 1.414L15 16.414V29a1 1 0 0 0 2 0V16.414z"
                                        data-original="#000000"
                                    />
                                </svg>
                                Upload Profile Image
                                <input
                                    type="file"
                                    id="avatar"
                                    className="hidden"
                                    multiple={false}
                                    accept="image/*"
                                    onChange={handleAvatarChange}
                                />
                                <p className="text-xs font-thin text-gray-400 mt-2 p-2">
                                    PNG and JPG are Allowed.
                                </p>
                            </label>
                        </div>
                        <div>
                            {avatar ? (
                                <img
                                    src={`${avatar}`}
                                    alt="avatar"
                                    className="w-32 h-32 rounded-full"
                                />
                            ) : (
                                <img
                                    src={`${url}/storage/uploads/${user.avatar}`}
                                    alt="avatar"
                                    className="w-32 h-32 rounded-full"
                                />
                            )}
                        </div>
                    </div>
                    <div className="flex justify-start items-center gap-3">
                        <div>
                            <label
                                htmlFor="cover"
                                className="bg-white text-gray-500 font-semibold rounded max-w-md h-32 flex flex-col items-center justify-center cursor-pointer border-2 border-gray-300 border-dashed mx-auto font-[sans-serif] text-xs"
                            >
                                <svg
                                    xmlns="http://www.w3.org/2000/svg"
                                    className="w-11 mb-2 fill-gray-500"
                                    viewBox="0 0 32 32"
                                >
                                    <path
                                        d="M23.75 11.044a7.99 7.99 0 0 0-15.5-.009A8 8 0 0 0 9 27h3a1 1 0 0 0 0-2H9a6 6 0 0 1-.035-12 1.038 1.038 0 0 0 1.1-.854 5.991 5.991 0 0 1 11.862 0A1.08 1.08 0 0 0 23 13a6 6 0 0 1 0 12h-3a1 1 0 0 0 0 2h3a8 8 0 0 0 .75-15.956z"
                                        data-original="#000000"
                                    />
                                    <path
                                        d="M20.293 19.707a1 1 0 0 0 1.414-1.414l-5-5a1 1 0 0 0-1.414 0l-5 5a1 1 0 0 0 1.414 1.414L15 16.414V29a1 1 0 0 0 2 0V16.414z"
                                        data-original="#000000"
                                    />
                                </svg>
                                Upload Background Image
                                <input
                                    type="file"
                                    id="cover"
                                    className="hidden"
                                    multiple={false}
                                    accept="image/*"
                                    onChange={handleCoverChange}
                                />
                                <p className="text-xs font-thin text-gray-400 mt-2 p-2">
                                    PNG and JPG are Allowed.
                                </p>
                            </label>
                        </div>

                        <div>
                            {cover ? (
                                <img
                                    src={`${cover}`}
                                    alt="cover"
                                    className="w-36 h-32 rounded-xl"
                                />
                            ) : (
                                <img
                                    src={`${url}/storage/uploads/${user.cover}`}
                                    alt="cover"
                                    className="w-36 h-32 rounded-xl"
                                />
                            )}
                        </div>
                    </div>

                    <div className="flex items-center gap-4">
                        <PrimaryButton>Save</PrimaryButton>
                    </div>
                </form>
            </div>
        </section>
    );
}
