import { FormEventHandler, useState } from "react";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import InputError from "@/Components/InputError";
import InputLabel from "@/Components/InputLabel";
import PrimaryButton from "@/Components/PrimaryButton";
import TextInput from "@/Components/TextInput";
import { Head, Link, router, useForm, usePage } from "@inertiajs/react";
import "react-phone-number-input/style.css";
import PhoneInput from "react-phone-number-input";
import { ArrowLeft, Eye, EyeOffIcon } from "lucide-react";

export default function Create() {

    const {errors} = usePage().props;

    const { data, setData, processing } = useForm({
        name: "",
        email: "",
        password: "",
        phone: "",
        password_confirmation: "",
        role:"",
    });
    const [value, setValue] = useState();
    const [showPassword, setShowPassword] = useState(false);
    const [showConfirmPassword, setShowConfirmPassword] = useState(false);

    const submit: FormEventHandler = (e) => {
        e.preventDefault();

        router.post(route("users.store"), { ...data, phone: value });
    };

    return (
        <AuthenticatedLayout>
            <Head title="Register" />

            <div className="flex justify-center items-center mt-10">
            <form onSubmit={submit} className="w-96 bg-white p-7 rounded-lg">
                 <Link href={route('users.index')}>
                    <ArrowLeft size={16} className="mb-3" />
                </Link>
                <div>
                    <InputLabel htmlFor="name" value="Name" />

                    <TextInput
                        id="name"
                        name="name"
                        value={data.name}
                        className="mt-1 block w-full"
                        autoComplete="name"
                        isFocused={true}
                        onChange={(e) => setData("name", e.target.value)}
                        required
                    />

                    <InputError message={errors.name} className="mt-2" />
                </div>

                <div className="mt-4">
                    <InputLabel htmlFor="email" value="Email" />
                    <TextInput
                            id="email"
                            type="email"
                            name="email"
                            value={data.email}
                            className="mt-1 block w-full"
                            autoComplete="username"
                            onChange={(e) => setData("email", e.target.value)}
                            required
                        />

                    <InputError message={errors.email} className="mt-2" />
                </div>

                <div className="mt-4">
                    <InputLabel htmlFor="phone" value="Phone Number" />
                    <PhoneInput
                        defaultCountry="AF"
                        placeholder="770000000"
                        value={value}
                        onChange={setValue as any}
                        required
                    />

                    <InputError message={errors.phone} className="mt-2" />
                </div>

                <div className="mt-4">
                    <InputLabel htmlFor="password" value="Password" />

                    <div className="flex justify-center items-center">
                        <TextInput
                            id="password"
                            type={`${showPassword? 'text': 'password'}`}
                            name="password"
                            value={data.password}
                            className="mt-1 block w-full"
                            autoComplete="new-password"
                            onChange={(e) => setData("password", e.target.value)}
                            required
                        />
                        <span onClick={()=>setShowPassword(!showPassword)}>
                        {showPassword?(<Eye />):(<EyeOffIcon />)}
                        </span>
                    </div>

                    <InputError message={errors.password} className="mt-2" />
                </div>

                <div className="mt-4">
                    <InputLabel
                        htmlFor="password_confirmation"
                        value="Confirm Password"
                    />

                    <div className="flex justify-center items-center">
                        <TextInput
                            id="password_confirmation"
                            type={`${showConfirmPassword?'text':'password'}`}
                            name="password_confirmation"
                            value={data.password_confirmation}
                            className="mt-1 block w-full"
                            autoComplete="new-password"
                            onChange={(e) =>
                                setData("password_confirmation", e.target.value)
                            }
                            required
                        />
                        <span onClick={()=>setShowConfirmPassword(!showConfirmPassword)}>
                            {showConfirmPassword?(<Eye />):(<EyeOffIcon />)}
                        </span>
                    </div>

                    <InputError
                        message={errors.password_confirmation}
                        className="mt-2"
                    />
                </div>

                <div className="mt-4">
                    <InputLabel
                        htmlFor="role"
                        value="Role"
                    />
                    <select 
                        name="role" 
                        id="role" 
                        value={data.role}
                        className="mt-1 block w-full"
                        onChange={(e) =>
                            setData("role", e.target.value)
                        }
                        required>
                        <option value="">--</option>
                        <option value="user">User</option>
                        <option value="admin">Admin</option>
                    </select>

                    <InputError
                        message={errors.password_confirmation}
                        className="mt-2"
                    />
                </div>

                <div className="flex items-center justify-end mt-4">

                    <PrimaryButton className="ms-4" disabled={processing}>
                        Register
                    </PrimaryButton>
                </div>
            </form>
            </div>
        </AuthenticatedLayout>
    );
}
