import { TableCell } from "@/Components/ui/table";
import { User } from "@/types";
import { DeleteUser } from "./DeleteUser";
import { url } from "@/lib/url";
import { Edit, Link2, ShoppingCart } from "lucide-react";
import { Link } from "@inertiajs/react";
import { Button } from "@/Components/ui/button";
import { router } from "@inertiajs/react";
import { Switch } from "@/Components/ui/switch";

const UserTableRow = ({ user }: { user: User }) => {
    const handleMediaToggle = () => {
        router.post(route("users.media.update", user.id), {
            id: user.id,
            media_active: !Boolean(user.media_active),
        });
    };

    const handleProductToggle = () => {
        router.post(route("users.product.update", user.id), {
            id: user.id,
            product_active: !Boolean(user.product_active),
        });
    };

    return (
        <>
            <TableCell>
                {user.avatar ? (
                    <img
                        src={`${url}/storage/uploads/${user.avatar}`}
                        width="45px"
                        height="45px"
                        className="rounded-full"
                        alt="img"
                    />
                ) : (
                    <img
                        src={`${url}/images/avatar.png`}
                        width="45px"
                        height="45px"
                        className="rounded-full"
                        alt="img"
                    />
                )}
            </TableCell>
            <TableCell>{user.name}</TableCell>
            <TableCell>{user.email}</TableCell>
            <TableCell>{user.phone}</TableCell>
            <TableCell>{user.role}</TableCell>
            <TableCell>
                <Switch
                    checked={user.media_active}
                    onCheckedChange={handleMediaToggle}
                />
            </TableCell>
            <TableCell>
                <Switch
                    checked={user.product_active}
                    onCheckedChange={handleProductToggle}
                />
            </TableCell>
            <TableCell>
                <div className="flex gap-2 justify-end">
                    <DeleteUser id={user.id} />
                    <Link href={route("users.edit", user.id)}>
                        <Button variant={"outline"}>
                            <Edit size={18} color="green" />
                        </Button>
                    </Link>
                    {Boolean(user.media_active) && (
                        <Link href={route("users.show", user.id)}>
                            <Button variant={"outline"}>
                                <Link2 size={18} color="blue" />
                            </Button>
                        </Link>
                    )}
                    {Boolean(user.product_active) && (
                        <Link href={route("user.store.index", user.id)}>
                            <Button variant={"outline"}>
                                <ShoppingCart size={18} color="orange" />
                            </Button>
                        </Link>
                    )}
                </div>
            </TableCell>
        </>
    );
};

export default UserTableRow;
