import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { Head, Link } from "@inertiajs/react";
import { ArrowLeft, PlusCircle, QrCode, UserIcon, X } from "lucide-react";
import { url } from "@/lib/url";
import { DeleteLink } from "./Partials/DeleteLink";
import { Button } from "@/Components/ui/button";
import EditDialogForm from "./Partials/EditDialogForm";
import { User } from "@/types";

type Media = {
    id: string;
    name: string;
    title: string;
    url: string;
    user_id: string;
};

export default function Show({
    success,
    medias,
    user,
}: {
    success: string;
    medias: Media[];
    user: User;
}) {
    return (
        <AuthenticatedLayout>
            <Head title="Links" />

            <div className="py-12">
                <div className="max-w-full md:max-w-3xl mx-auto sm:px-6 lg:px-8">
                    <div className="flex justify-between">
                        <Link href={route("users.index")}>
                            <ArrowLeft size={20} />
                        </Link>
                        <Link href={route("userLinks.create", user.id)}>
                            <Button variant={"outline"} className="flex gap-1">
                                <PlusCircle size={14} /> <p>Add New Link</p>
                            </Button>
                        </Link>
                    </div>

                    <div className="bg-white overflow-hidden shadow-sm sm:rounded-lg mt-1">
                        <div className="p-6 text-gray-900">
                            <div className="flex justify-between items-center">
                                <p className="flex justify-center items-center"> <UserIcon /> {user.name} Links</p>
                                <Link href={route("qrcode", user.id)}>
                                    <Button variant={"outline"}>
                                        <QrCode size={18} />
                                    </Button>
                                </Link>
                                <p> ({medias.length} Links) </p>
                            </div>
                            <div className="flex flex-col gap-3 mt-3">
                                {medias.map((media: Media) => (
                                    <div
                                        key={media.id}
                                        className="bg-slate-100 p-4 rounded-lg"
                                    >
                                        <div className="flex justify-around">
                                            <div>
                                                <img
                                                    src={`${url}/storage/images/${media.name}.png`}
                                                    alt={media.name}
                                                />
                                            </div>
                                            <div>
                                                {media.title
                                                    .charAt(0)
                                                    .toUpperCase() +
                                                    media.title.slice(1)}
                                            </div>
                                            <div className="flex justify-center items-center gap-2">
                                                <>
                                                    <DeleteLink id={media.id} />
                                                    <EditDialogForm
                                                        userId={user.id}
                                                        media={media}
                                                        svg={`${url}/storage/images/${media.name}.png`}
                                                        success={success}
                                                    />
                                                </>
                                            </div>
                                        </div>
                                    </div>
                                ))}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
