import { Store } from "./custom";

export interface User {
    id: string;
    name: string;
    email: string;
    email_verified_at?: string;
    avatar?: string;
    cover?: string;
    phone?: string;
    role: string;
    company?: string;
    job?: string;
    bio?: string;
    mobile?: string;
    mail?: string;
    media_active: boolean;
    product_active: boolean;
    address?: string;
    store?: Store;
}

export type PageProps<
    T extends Record<string, unknown> = Record<string, unknown>
> = T & {
    auth: {
        user: User;
    };
    flash?: {
        success: string;
        error: string;
    };
};
