<?php

namespace App\Http\Controllers;

use App\Models\Media;
use App\Models\User;
use Inertia\Inertia;
use Illuminate\Support\Str;
use JeroenDesloovere\VCard\VCard;

class QrCodeController extends Controller
{
    public function show($userId)
    {
        $user = User::findOrFail($userId);
        $url = env('APP_URL', 'https://ertebatasan.com') . '/' . $userId . '/display';

        return Inertia::render('Links/Generate', ['url' => $url, 'user' => $user]);
    }

    public function display($id)
    {
        $user = User::with('store')->findOrFail($id);
        $medias = Media::where('user_id', $user->id)->get();
        return Inertia::render('Links/Share', ['user' => $user, 'medias' => $medias]);
    }

    public function downloadVCard($id)
    {
        $user = User::findOrFail($id);
        $medias = Media::where('user_id', $user->id)->get();

        $vCard = new VCard();
        $vCard->addName($user->name);
        $vCard->addEmail($user->email, 'EMAIL;TYPE=INTERNET,WORK');
        $vCard->addEmail($user->mail, 'EMAIL;TYPE=INTERNET,HOME');
        $vCard->addPhoneNumber($user->phone, 'PREF;WORK;VOICE');
        $vCard->addPhoneNumber($user->mobile, 'PREF;HOME;VOICE');
        $vCard->addJobtitle($user->job);
        $vCard->addCompany($user->company);
        $vCard->addAddress($user->address);

        if ($user->avatar && file_exists(public_path('uploads/') . $user->avatar)) {
            $vCard->addPhoto(public_path('uploads/') . $user->avatar);
        }

        if($user->media_active == 1){
            foreach ($medias as $media) {
                if($media->name == 'gmail'){
                    $vCard->addEmail($media->url,'EMAIL;TYPE=INTERNET,WORK');
                }else{
                    $vCard->addURL($media->url, 'WORK');
                }
            }
        }

        if($user->product_active == 1){
            $vCard->addURL(route("store.display.index",$user->store->id));
        }

        $userName = $user->name;
        $filename = Str::slug($userName) . '_contacts.vcf';
        $vcfContent = $vCard->getOutput();
        return response($vcfContent)->header('Content-Type', 'text/x-vcard')->header('Content-Disposition', 'attachment; filename="' . $filename . '"');
    }
}
