"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(require("react"));
const node_pixels_1 = require("node-pixels");
const PixelsImage = (_a) => {
    var { onFilter, type, filter, brightness, saturation, contrast, verticalFlip, horizontalFlip, src } = _a, props = __rest(_a, ["onFilter", "type", "filter", "brightness", "saturation", "contrast", "verticalFlip", "horizontalFlip", "src"]);
    const ref = (0, react_1.createRef)();
    const [editObject, setEditObject] = (0, react_1.useState)({});
    const [isVisible, setIsVisible] = (0, react_1.useState)(false);
    const [source, setSource] = (0, react_1.useState)();
    const [data, setData] = (0, react_1.useState)();
    const [isFiltered, setIsFiltered] = (0, react_1.useState)(false);
    const load = () => __awaiter(void 0, void 0, void 0, function* () {
        if (data && ref.current) {
            const canvas = ref.current;
            let changed = false;
            let { context, imageData } = data;
            setIsFiltered(true);
            if (editObject.filter) {
                yield (0, node_pixels_1.loadFilter)(imageData, editObject.filter);
                changed = true;
            }
            const { brightness, saturation, contrast } = editObject;
            if (brightness || saturation || contrast) {
                yield (0, node_pixels_1.adjustColors)(imageData, { brightness, saturation, contrast });
                changed = true;
            }
            if (changed)
                (0, node_pixels_1.applyChanges)(imageData, context);
            if (editObject.verticalFlip) {
                (0, node_pixels_1.setVerticalFlip)(canvas, context);
                changed = true;
            }
            if (editObject.horizontalFlip) {
                (0, node_pixels_1.setHorizontalFlip)(canvas, context);
                changed = true;
            }
            if (onFilter && source)
                onFilter((0, node_pixels_1.getExportObject)(canvas, source.type));
        }
    });
    (0, react_1.useEffect)(() => {
        setEditObject({
            filter,
            brightness,
            contrast,
            saturation,
            lastChange: Date.now(),
            verticalFlip,
            horizontalFlip,
        });
    }, [filter, brightness, contrast, saturation, verticalFlip, horizontalFlip]);
    (0, react_1.useEffect)(() => {
        if (ref && ref.current) {
            const observer = new IntersectionObserver((ent) => {
                const v = !!ent.find((e) => e.isIntersecting);
                if (v != isVisible)
                    setIsVisible(v);
            });
            observer.observe(ref.current);
        }
    }, [ref.current]);
    (0, react_1.useEffect)(() => {
        if (ref.current && data && isVisible && !isFiltered)
            load();
    }, [data, isVisible, isFiltered, ref.current]);
    (0, react_1.useEffect)(() => {
        if (ref && ref.current && source) {
            setIsFiltered(false);
            setData((0, node_pixels_1.drawImageSource)(ref.current, source));
        }
    }, [source, ref.current, editObject.lastChange]);
    (0, react_1.useEffect)(() => {
        if (src) {
            if (src instanceof HTMLImageElement ||
                src instanceof HTMLCanvasElement ||
                typeof src === "string") {
                (() => __awaiter(void 0, void 0, void 0, function* () {
                    const source = yield (0, node_pixels_1.getImageSource)(src, type);
                    setSource(source);
                }))();
            }
            else
                setSource(src);
        }
    }, [src]);
    if (src)
        return react_1.default.createElement("canvas", Object.assign({}, props, { ref: ref }));
};
exports.default = PixelsImage;
