import { Store } from "@/types/custom";
import { Link } from "@inertiajs/react";

export default function ClientFooter({ store }: { store: Store }) {
    return (
        <footer className="bg-white rounded-lg shadow m-4 dark:bg-gray-800">
            <div className="w-full mx-auto max-w-screen-xl p-4 md:flex md:items-center md:justify-between">
                <span className="text-sm text-gray-900 sm:text-center dark:text-gray-400">
                    © 2024{" "}
                    <a
                        href="https://rahmat.vercel.app"
                        className="underline"
                        target="_blank"
                    >
                        Ertebatasan
                    </a>
                    . All Rights Reserved.
                </span>
                <ul className="flex flex-wrap items-center mt-3 text-sm font-medium text-gray-900 sm:mt-0">
                    <li>
                        <Link
                            href={route("store.display.index", store.id)}
                            className="hover:underline me-4 md:me-6"
                        >
                            Products
                        </Link>
                    </li>
                    <li>
                        <Link
                            href={route("store.contact", store.id)}
                            className="hover:underline me-4 md:me-6"
                        >
                            Contact Us
                        </Link>
                    </li>
                </ul>
            </div>
        </footer>
    );
}
