import { url } from "@/lib/url";
import { Store } from "@/types/custom";
import { Link } from "@inertiajs/react";
import { Menu, PhoneCall, Shirt, X } from "lucide-react";
import { useState } from "react";
import NavLink from "./NavLink";

export default function ClientHeader({ store }: { store: Store }) {
    const [isOpen, setIsOpen] = useState(false);

    return (
        <nav className="bg-white border-gray-200 dark:bg-gray-900">
            <div className="max-w-screen-xl flex flex-wrap items-center justify-between mx-auto p-4">
                <Link
                    href={route("store.display.index", store.id)}
                    className="flex items-center space-x-3 rtl:space-x-reverse"
                >
                    {store.logo ? (
                        <img
                            src={`${url}/storage/store/${store.logo}`}
                            alt={store?.name}
                            className="h-8 rounded-full"
                        />
                    ) : (
                        <img
                            src={`${url}/images/logo.jpg`}
                            alt="logo"
                            className="h-8 rounded-full"
                        />
                    )}
                    <span className="self-center text-2xl font-semibold whitespace-nowrap dark:text-white text-blue-700">
                        {store.name}
                    </span>
                </Link>
                <button
                    data-collapse-toggle="navbar-default"
                    type="button"
                    className="inline-flex items-center p-2 w-10 h-10 justify-center text-sm text-gray-500 rounded-lg md:hidden hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-gray-200 dark:text-gray-400 dark:hover:bg-gray-700 dark:focus:ring-gray-600"
                    aria-controls="navbar-default"
                    aria-expanded="false"
                    onClick={() => setIsOpen(!isOpen)}
                >
                    <span className="sr-only">Open main menu</span>

                    {isOpen ? <X /> : <Menu />}
                </button>
                <div
                    className={` ${
                        isOpen ? null : "hidden"
                    } w-full md:block md:w-auto`}
                    id="navbar-default"
                >
                    <ul className="font-medium flex flex-col p-4 md:p-0 mt-4 border border-gray-100 rounded-lg bg-gray-50 md:flex-row md:space-x-8 rtl:space-x-reverse md:mt-0 md:border-0 md:bg-white dark:bg-gray-800 md:dark:bg-gray-900 dark:border-gray-700">
                        <li>
                            <NavLink
                                href={route("store.display.index", store.id)}
                                active={route().current("store.display.index")}
                                className="flex gap-1"
                            >
                                <Shirt size={18} />
                                Products
                            </NavLink>
                        </li>
                        <li>
                            <NavLink
                                href={route("store.contact", store.id)}
                                active={route().current("store.contact")}
                                className="flex gap-1"
                            >
                                <PhoneCall size={18} />
                                Contact
                            </NavLink>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>
    );
}
