import { Link } from "@inertiajs/react";

const Footer = () => {
    return (
        <footer className="bg-white rounded-lg shadow m-4 dark:bg-gray-800 mt-10">
            <div className="w-full mx-auto max-w-screen-xl p-4 md:flex md:items-center md:justify-between">
                <span className="text-sm text-gray-900 sm:text-center dark:text-gray-400">
                    © 2024{" "}
                    <a
                        href="https://rahmat.vercel.app"
                        className="underline"
                        target="_blank"
                    >
                        Ertebatasan
                    </a>
                    . All Rights Reserved.
                </span>
                <ul className="flex flex-wrap items-center mt-3 text-sm font-medium text-gray-900 sm:mt-0">
                    <li>
                        <Link href="/" className="hover:underline me-4 md:me-6">
                            Home
                        </Link>
                    </li>
                    <li>
                        <Link
                            href="/contacts/create"
                            className="hover:underline me-4 md:me-6"
                        >
                            Contact Us
                        </Link>
                    </li>
                    <li>
                        <Link
                            href="/login"
                            className="hover:underline me-4 md:me-6"
                        >
                            Login
                        </Link>
                    </li>
                </ul>
            </div>
        </footer>
    );
};

export default Footer;
