import { useState, PropsWithChildren } from "react";
import Dropdown from "@/Components/Dropdown";
import NavLink from "@/Components/NavLink";
import ResponsiveNavLink from "@/Components/ResponsiveNavLink";
import { Link, usePage } from "@inertiajs/react";
import { url } from "@/lib/url";
import {
    Home,
    Link2,
    PhoneCall,
    ShoppingCart,
    Store,
    Tags,
    User,
    Users,
} from "lucide-react";

export default function Authenticated({ children }: PropsWithChildren) {
    const user = usePage().props.auth.user;
    const flash = usePage().props.flash;

    const [showingNavigationDropdown, setShowingNavigationDropdown] =
        useState(false);

    return (
        <div className="min-h-screen bg-gray-100">
            <nav className="bg-white border-b border-gray-100">
                <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <div className="flex justify-between h-16">
                        <div className="flex">
                            <div className="shrink-0 flex items-center">
                                <Link href="/">
                                    <img
                                        src={`${url}/images/logo.jpg`}
                                        className="rounded-xl p-6 w-24 h-24"
                                        alt="logo"
                                    />
                                </Link>
                            </div>

                            <div className="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                                <NavLink
                                    href={route("dashboard")}
                                    active={route().current("dashboard")}
                                    className="flex gap-1"
                                >
                                    <Home size={16} />
                                    Home
                                </NavLink>
                            </div>
                            {Boolean(user.media_active) && (
                                <div className="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                                    <NavLink
                                        href={route("links")}
                                        active={route().current("links")}
                                        className="flex gap-1"
                                    >
                                        <Link2 size={16} /> Links
                                    </NavLink>
                                </div>
                            )}
                            {user.role === "user" && (
                                <>
                                    {Boolean(user.product_active) && (
                                        <>
                                            <div className="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                                                <NavLink
                                                    href={route(
                                                        "category.index"
                                                    )}
                                                    active={route().current(
                                                        "category.index"
                                                    )}
                                                    className="flex gap-1"
                                                >
                                                    <Tags size={16} />
                                                    Category
                                                </NavLink>
                                            </div>
                                            <div className="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                                                <NavLink
                                                    href={route(
                                                        "products.index"
                                                    )}
                                                    active={route().current(
                                                        "products.index"
                                                    )}
                                                    className="flex gap-1"
                                                >
                                                    <ShoppingCart size={16} />
                                                    Product
                                                </NavLink>
                                            </div>
                                            <div className="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                                                <NavLink
                                                    href={route("store.index")}
                                                    active={route().current(
                                                        "store.index"
                                                    )}
                                                    className="flex gap-1"
                                                >
                                                    <Store size={16} /> Store
                                                </NavLink>
                                            </div>
                                        </>
                                    )}

                                    <div className="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                                        <NavLink
                                            href={route("profile.edit")}
                                            active={route().current(
                                                "profile.edit"
                                            )}
                                        >
                                            <User size={18} />
                                            Profile
                                        </NavLink>
                                    </div>
                                </>
                            )}
                            {user.role === "admin" && (
                                <>
                                    <div className="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                                        <NavLink
                                            href={route("users.index")}
                                            active={route().current(
                                                "users.index"
                                            )}
                                            className="flex gap-1"
                                        >
                                            <Users size={16} />
                                            Users
                                        </NavLink>
                                    </div>
                                    <div className="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                                        <NavLink
                                            href={route("admin.products.all")}
                                            active={route().current(
                                                "admin.products.all"
                                            )}
                                            className="flex gap-1"
                                        >
                                            <ShoppingCart size={16} /> Products
                                        </NavLink>
                                    </div>
                                    <div className="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                                        <NavLink
                                            href={route("contact.index")}
                                            active={route().current(
                                                "contact.index"
                                            )}
                                            className="flex gap-1"
                                        >
                                            <PhoneCall size={16} />
                                            Contacts
                                        </NavLink>
                                    </div>
                                </>
                            )}
                        </div>

                        <div className="hidden sm:flex sm:items-center sm:ms-6">
                            <div className="ms-3 relative">
                                <Dropdown>
                                    <Dropdown.Trigger>
                                        <span className="inline-flex rounded-md">
                                            <button
                                                type="button"
                                                className="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 bg-white hover:text-gray-700 focus:outline-none transition ease-in-out duration-150"
                                            >
                                                {user.name}

                                                <svg
                                                    className="ms-2 -me-0.5 h-4 w-4"
                                                    xmlns="http://www.w3.org/2000/svg"
                                                    viewBox="0 0 20 20"
                                                    fill="currentColor"
                                                >
                                                    <path
                                                        fillRule="evenodd"
                                                        d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                                        clipRule="evenodd"
                                                    />
                                                </svg>
                                            </button>
                                        </span>
                                    </Dropdown.Trigger>

                                    <Dropdown.Content>
                                        {user.role === "admin" && (
                                            <Dropdown.Link
                                                href={route("profile.edit")}
                                            >
                                                Profile
                                            </Dropdown.Link>
                                        )}
                                        <Dropdown.Link
                                            href={route("logout")}
                                            method="post"
                                            as="button"
                                            className="text-red-700"
                                        >
                                            Log Out
                                        </Dropdown.Link>
                                    </Dropdown.Content>
                                </Dropdown>
                            </div>
                        </div>

                        <div className="-me-2 flex items-center sm:hidden">
                            <button
                                onClick={() =>
                                    setShowingNavigationDropdown(
                                        (previousState) => !previousState
                                    )
                                }
                                className="inline-flex items-center justify-center p-2 rounded-md text-gray-400 hover:text-gray-500 hover:bg-gray-100 focus:outline-none focus:bg-gray-100 focus:text-gray-500 transition duration-150 ease-in-out"
                            >
                                <svg
                                    className="h-6 w-6"
                                    stroke="currentColor"
                                    fill="none"
                                    viewBox="0 0 24 24"
                                >
                                    <path
                                        className={
                                            !showingNavigationDropdown
                                                ? "inline-flex"
                                                : "hidden"
                                        }
                                        strokeLinecap="round"
                                        strokeLinejoin="round"
                                        strokeWidth="2"
                                        d="M4 6h16M4 12h16M4 18h16"
                                    />
                                    <path
                                        className={
                                            showingNavigationDropdown
                                                ? "inline-flex"
                                                : "hidden"
                                        }
                                        strokeLinecap="round"
                                        strokeLinejoin="round"
                                        strokeWidth="2"
                                        d="M6 18L18 6M6 6l12 12"
                                    />
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>

                <div
                    className={
                        (showingNavigationDropdown ? "block" : "hidden") +
                        " sm:hidden"
                    }
                >
                    <div className="space-y-1">
                        <ResponsiveNavLink
                            href={route("dashboard")}
                            active={route().current("dashboard")}
                        >
                            Home
                        </ResponsiveNavLink>
                    </div>
                    {Boolean(user.media_active) && (
                        <div className="space-y-1">
                            <ResponsiveNavLink
                                href={route("links")}
                                active={route().current("links")}
                            >
                                Links
                            </ResponsiveNavLink>
                        </div>
                    )}
                    {user.role === "user" && (
                        <>
                            {Boolean(user.product_active) && (
                                <>
                                    <div className="space-y-1">
                                        <ResponsiveNavLink
                                            href={route("products.index")}
                                            active={route().current(
                                                "products.index"
                                            )}
                                        >
                                            Product
                                        </ResponsiveNavLink>
                                    </div>
                                    <div className="space-y-1">
                                        <ResponsiveNavLink
                                            href={route("category.index")}
                                            active={route().current(
                                                "category.index"
                                            )}
                                        >
                                            Category
                                        </ResponsiveNavLink>
                                    </div>
                                    <div className="pt-2 pb-3 space-y-1">
                                        <ResponsiveNavLink
                                            href={route("store.index")}
                                            active={route().current(
                                                "store.index"
                                            )}
                                        >
                                            Store
                                        </ResponsiveNavLink>
                                    </div>
                                </>
                            )}
                            <div className="space-y-1">
                                <ResponsiveNavLink
                                    href={route("profile.edit")}
                                    active={route().current("profile.edit")}
                                >
                                    Profile
                                </ResponsiveNavLink>
                            </div>
                        </>
                    )}

                    {user.role === "admin" && (
                        <>
                            {/* <div className="pt-2 pb-3 space-y-1">
                                <ResponsiveNavLink
                                    href={route("qrcode")}
                                    active={route().current("qrcode")}
                                >
                                    Share
                                </ResponsiveNavLink>
                            </div> */}
                            <div className="space-y-1">
                                <ResponsiveNavLink
                                    href={route("users.index")}
                                    active={route().current("users.index")}
                                >
                                    Users
                                </ResponsiveNavLink>
                            </div>
                            <div className="pt-2 pb-3 space-y-1">
                                <ResponsiveNavLink
                                    href={route("admin.products.all")}
                                    active={route().current(
                                        "admin.products.all"
                                    )}
                                >
                                    Products
                                </ResponsiveNavLink>
                            </div>
                            <div className="space-y-1">
                                <ResponsiveNavLink
                                    href={route("contact.index")}
                                    active={route().current("contact.index")}
                                >
                                    Contacts
                                </ResponsiveNavLink>
                            </div>
                        </>
                    )}
                    <div className="pt-4 pb-1 border-t border-gray-200">
                        <div className="px-4">
                            <div className="font-medium text-base text-gray-800">
                                {user.name}
                            </div>
                            <div className="font-medium text-sm text-gray-500">
                                {user.email}
                            </div>
                        </div>

                        <div className="mt-3 space-y-1">
                            {/* <ResponsiveNavLink href={route("profile.edit")}>
                                Profile
                            </ResponsiveNavLink> */}
                            <ResponsiveNavLink
                                method="post"
                                href={route("logout")}
                                as="button"
                            >
                                Log Out
                            </ResponsiveNavLink>
                        </div>
                    </div>
                </div>
            </nav>
            <main>
                {flash?.success && (
                    <div className="flex justify-center items-center mt-1 mb-[-50px]">
                        <div
                            id="toast-success"
                            className="flex items-center w-full max-w-xs p-2 mb-4 text-green-500 bg-green-100 rounded-lg shadow dark:text-gray-400 dark:bg-gray-800"
                            role="alert"
                        >
                            <div className="inline-flex items-center justify-center flex-shrink-0 w-8 h-8 text-green-500 bg-green-100 rounded-lg dark:bg-green-800 dark:text-green-200">
                                <svg
                                    className="w-5 h-5"
                                    aria-hidden="true"
                                    xmlns="http://www.w3.org/2000/svg"
                                    fill="currentColor"
                                    viewBox="0 0 20 20"
                                >
                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z" />
                                </svg>
                                <span className="sr-only">Check icon</span>
                            </div>
                            <div className="ms-3 text-sm font-normal">
                                {flash.success}
                            </div>
                        </div>
                    </div>
                )}
                {flash?.error && (
                    <div className="flex justify-center items-center mt-1 mb-[-50px]">
                        <div
                            id="toast-danger"
                            className="flex items-center w-full max-w-xs p-2 mb-4 text-red-500 bg-red-100 rounded-lg shadow dark:text-gray-400 dark:bg-gray-800"
                            role="alert"
                        >
                            <div className="inline-flex items-center justify-center flex-shrink-0 w-8 h-8 text-red-500 bg-red-100 rounded-lg dark:bg-red-800 dark:text-red-200">
                                <svg
                                    className="w-5 h-5"
                                    aria-hidden="true"
                                    xmlns="http://www.w3.org/2000/svg"
                                    fill="currentColor"
                                    viewBox="0 0 20 20"
                                >
                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 11.793a1 1 0 1 1-1.414 1.414L10 11.414l-2.293 2.293a1 1 0 0 1-1.414-1.414L8.586 10 6.293 7.707a1 1 0 0 1 1.414-1.414L10 8.586l2.293-2.293a1 1 0 0 1 1.414 1.414L11.414 10l2.293 2.293Z" />
                                </svg>
                                <span className="sr-only">Error icon</span>
                            </div>
                            <div className="ms-3 text-sm font-normal">
                                {flash.error}
                            </div>
                        </div>
                    </div>
                )}
                {children}
            </main>
        </div>
    );
}
