import { url } from "@/lib/url";
import { Link } from "@inertiajs/react";
import { PropsWithChildren } from "react";

export default function Guest({ children }: PropsWithChildren) {
    return (
        <div className="min-h-screen flex flex-col sm:justify-center items-center pt-6 sm:pt-0 bg-gray-100">
            <div className="bg-gray-100 rounded-full p-4">
                <Link href="/">
                    <img
                        src={`${url}/images/logo.jpg`}
                        className="rounded-xl p-3 w-24 h-24"
                        alt="logo"
                    />
                </Link>
            </div>

            <div className="w-full sm:max-w-md mt-6 px-6 py-4 bg-white shadow-md overflow-hidden sm:rounded-lg">
                {children}
            </div>
        </div>
    );
}
