import Pagination from "@/Components/Pagination";
import TextInput from "@/Components/TextInput";
import { Button } from "@/Components/ui/button";
import {
    Table,
    TableBody,
    TableCaption,
    TableHead,
    TableHeader,
    TableRow,
} from "@/Components/ui/table";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { Head, Link, useForm } from "@inertiajs/react";
import { FilterXIcon } from "lucide-react";
import UserTableRow from "./Partials/UserTableRow";
import { Contact } from "@/types/custom";

export default function Index({ contacts }: { contacts: Contact }) {
    const { data, setData, get, processing } = useForm({
        search: "",
    });
    const handleUserSearch = (e: React.FormEvent) => {
        e.preventDefault();
        //@ts-ignore
        get(route("contact.index"), { data });
    };

    return (
        <AuthenticatedLayout>
            <Head title="Contacts" />

            <div className="py-12">
                <div className="max-w-full md:max-w-4xl mx-auto sm:px-6 lg:px-8">
                    <div className="flex justify-end gap-2">
                        <Link
                            href={route("contact.index")}
                            className="flex justify-center items-center"
                        >
                            <FilterXIcon size={24} color="black" />
                        </Link>
                        <form onSubmit={handleUserSearch}>
                            <TextInput
                                value={data.search}
                                onChange={(e) =>
                                    setData({ search: e.target.value })
                                }
                                placeholder="Search email or subject..."
                                className="text-sm w-[250px] mr-1"
                                required
                            />
                            <Button type="submit" disabled={processing}>
                                {processing ? "Search..." : "Search"}
                            </Button>
                        </form>
                    </div>
                    <div className="bg-white overflow-hidden shadow-sm sm:rounded-lg mt-1">
                        <div className="p-6 text-gray-900">
                            <Table>
                                <TableCaption>List of feedbacks.</TableCaption>
                                <TableHeader>
                                    <TableRow>
                                        <TableHead className="w-[100px]">
                                            Name
                                        </TableHead>
                                        <TableHead>Email</TableHead>
                                        <TableHead>Subject</TableHead>
                                        <TableHead>Message</TableHead>
                                        <TableHead>Action</TableHead>
                                    </TableRow>
                                </TableHeader>
                                <TableBody>
                                    {
                                        //@ts-ignore
                                        contacts.data.map(
                                            (contact: Contact) => (
                                                <TableRow key={contact.id}>
                                                    <UserTableRow
                                                        user={contact}
                                                    />
                                                </TableRow>
                                            )
                                        )
                                    }
                                </TableBody>
                            </Table>
                            <Pagination
                                //@ts-ignore
                                links={contacts.links}
                            />
                        </div>
                    </div>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
