import {
    AlertDialog,
    AlertDialogAction,
    AlertDialogCancel,
    AlertDialogContent,
    AlertDialogDescription,
    AlertDialogFooter,
    AlertDialogHeader,
    AlertDialogTitle,
    AlertDialogTrigger,
} from "@/Components/ui/alert-dialog";
import { router } from "@inertiajs/react";

export function DeleteLink({ id }: { id: number }) {
    function handleDelete(id: any) {
        router.delete(route("contact.delete", id), id);
    }

    return (
        <AlertDialog>
            <AlertDialogTrigger asChild>
            <div
                className="w-7 mt-2 shadow-md text-red-600 px-2 cursor-pointer hover:scale-110 transition-all rounded-full bg-slate-300 flex justify-center items-center"
            >
                x
            </div>
            </AlertDialogTrigger>
            <AlertDialogContent>
                <AlertDialogHeader>
                    <AlertDialogTitle>
                        Are you absolutely sure?
                    </AlertDialogTitle>
                    <AlertDialogDescription>
                        This action cannot be undone. This will permanently
                        delete user message.
                    </AlertDialogDescription>
                </AlertDialogHeader>
                <AlertDialogFooter>
                    <AlertDialogCancel>Cancel</AlertDialogCancel>
                    <AlertDialogAction 
                        onClick={() => handleDelete(id)}
                        className="bg-red-600 text-white hover:bg-red-800"
                    >
                        Continue
                    </AlertDialogAction>
                </AlertDialogFooter>
            </AlertDialogContent>
        </AlertDialog>
    );
}
