import { Button } from "@/Components/ui/button";
import { Input } from "@/Components/ui/input";
import { Label } from "@/Components/ui/label";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { Head, Link } from "@inertiajs/react";
import { ArrowLeft, CopyIcon, Download } from "lucide-react";
import QRCode from "react-qr-code";
import { useRef, useState } from "react";
import copy from "copy-to-clipboard";
import { exportComponentAsJPEG } from "react-component-export-image";
import { User } from "@/types";

export default function Generate({
    url,
    user,
}: {
    url: string;
    user: User;
}) {
    const [copyText, setCopyText] = useState(url);
    const componentRef = useRef(null);

    const handleCopyText = (e: React.ChangeEvent<HTMLInputElement>) => {
        setCopyText(e.target.value);
    };

    const copyToClipboard = () => {
        copy(copyText);
    };

    return (
        <AuthenticatedLayout>
            <Head title="Share" />

            <div className="py-12">
                <div className="max-w-full md:max-w-3xl mx-auto sm:px-6 lg:px-8">
                    <div className="bg-white overflow-hidden shadow-sm sm:rounded-lg mt-1">
                        <div className="p-6 text-gray-900">
                            <div className="flex justify-between items-center">
                                <Link href={route("users.show", user.id)}>
                                    <ArrowLeft size={20} />
                                </Link>
                                <Button
                                    variant={"outline"}
                                    onClick={() =>
                                        exportComponentAsJPEG(componentRef)
                                    }
                                >
                                    <Download size={20} />
                                </Button>
                            </div>
                            <div
                                className="flex flex-col justify-center items-center p-10"
                                ref={componentRef}
                            >
                                <p className="mb-2 font-semibold">{user.name}</p>
                                <QRCode
                                    size={100}
                                    style={{
                                        height: "auto",
                                        maxWidth: "50%",
                                        width: "50%",
                                    }}
                                    value={url}
                                    viewBox={`0 0 256 256`}
                                />
                            </div>
                        </div>
                        <div className="flex items-center space-x-2 py-10 px-20">
                            <div className="grid flex-1 gap-2">
                                <Label htmlFor="link" className="sr-only">
                                    Link
                                </Label>
                                <Input
                                    id="link"
                                    value={copyText}
                                    onChange={handleCopyText}
                                    readOnly
                                />
                            </div>
                            <Button
                                type="submit"
                                size="sm"
                                className="px-3"
                                onClick={copyToClipboard}
                            >
                                <span className="sr-only">Copy</span>
                                <CopyIcon className="h-4 w-4" />
                            </Button>
                        </div>
                    </div>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
