import ClientFooter from "@/Components/ClientFooter";
import ClientHeader from "@/Components/ClientHeader";
import { User } from "@/types";
import { Store } from "@/types/custom";
import { Head } from "@inertiajs/react";
import { Clock, Globe, Mail, Phone } from "lucide-react";

export default function Contact({ store, user }: { store: Store; user: User }) {
    return (
        <>
            <Head title="contact us" />
            <ClientHeader store={store} />
            <div className="bg-gray-100 min-h-screen py-12 md:-mb-20">
                <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <div className="lg:text-center">
                        <p className="mt-2 text-3xl leading-8 font-extrabold tracking-tight text-gray-900 sm:text-4xl">
                            {store?.name}
                        </p>
                        <p className="mt-4 max-w-2xl text-xl text-gray-500 lg:mx-auto">
                            {store?.description}
                        </p>
                    </div>

                    <div className="mt-10">
                        <dl className="space-y-10 md:space-y-0 md:grid md:grid-cols-2 md:gap-x-8 md:gap-y-10">
                            <div className="flex">
                                <div className="flex-shrink-0">
                                    <div className="flex items-center justify-center h-12 w-12 rounded-md bg-indigo-500 text-white">
                                        <Globe />
                                    </div>
                                </div>
                                <div className="ml-4">
                                    <dt className="text-lg leading-6 font-medium text-gray-900">
                                        Address
                                    </dt>
                                    <dd className="mt-2 text-base text-wrap text-gray-500">
                                        {user?.address}
                                    </dd>
                                </div>
                            </div>

                            <div className="flex">
                                <div className="flex-shrink-0">
                                    <div className="flex items-center justify-center h-12 w-12 rounded-md bg-indigo-500 text-white">
                                        <Phone />
                                    </div>
                                </div>
                                <div className="ml-4">
                                    <dt className="text-lg leading-6 font-medium text-gray-900">
                                        Phone number
                                    </dt>
                                    <dd className="mt-2 text-base text-gray-500">
                                        {user?.phone} <br />
                                        {user?.mobile}
                                    </dd>
                                </div>
                            </div>

                            <div className="flex">
                                <div className="flex-shrink-0">
                                    <div className="flex items-center justify-center h-12 w-12 rounded-md bg-indigo-500 text-white">
                                        <Mail />
                                    </div>
                                </div>
                                <div className="ml-4">
                                    <dt className="text-lg leading-6 font-medium text-gray-900">
                                        Email
                                    </dt>
                                    <dd className="mt-2 text-base text-gray-500">
                                        {user?.email} <br />
                                        {user?.mail}
                                    </dd>
                                </div>
                            </div>

                            <div className="flex">
                                <div className="flex-shrink-0">
                                    <div className="flex items-center justify-center h-12 w-12 rounded-md bg-indigo-500 text-white">
                                        <Clock />
                                    </div>
                                </div>
                                <div className="ml-4">
                                    <dt className="text-lg leading-6 font-medium text-gray-900">
                                        Store Hours
                                    </dt>
                                    <dd className="mt-2 text-base text-gray-500">
                                        Saturday - Friday: 8am to 8pm
                                    </dd>
                                </div>
                            </div>
                        </dl>
                    </div>
                </div>
            </div>
            <ClientFooter store={store} />
        </>
    );
}
