import { url } from "@/lib/url";
import ModalImage from "react-modal-image";

const ImageGallery = ({ images }: { images: Array<string> }) => {
    return (
        <div style={{ display: "flex", gap: "10px" }}>
            {images.map((image, index) => (
                <ModalImage
                    hideDownload={true}
                    hideZoom={true}
                    showRotate={true}
                    key={index}
                    small={`${url}/storage/products/${image}`}
                    medium={`${url}/storage/products/${image}`}
                    large={`${url}/storage/products/${image}`}
                    alt={`Image ${index + 1}`}
                    className="w-20 h-20"
                />
            ))}
        </div>
    );
};

export default ImageGallery;
