import { TableCell } from "@/Components/ui/table";
import { Eye } from "lucide-react";
import { Link } from "@inertiajs/react";
import { Button } from "@/Components/ui/button";
import { Product, Store } from "@/types/custom";
import ImageGallery from "./ImageGallery";

const ProductTableRow = ({
    product,
    store,
}: {
    product: Product;
    store: Store;
}) => {
    return (
        <>
            <TableCell>
                <ImageGallery images={product.images} />
            </TableCell>
            <TableCell>{product.name}</TableCell>
            <TableCell>{product.description.slice(0, 20)} ...</TableCell>
            <TableCell>
                {product.price>0?(
                        `${product.price} AF`
                ):null}
            </TableCell>
            <TableCell>
                <Link href={`/store/${store.id}/${product.id}`}>
                    <Button variant={"outline"}>
                        <Eye size={18} />
                    </Button>
                </Link>
            </TableCell>
        </>
    );
};

export default ProductTableRow;
