import { TableCell } from "@/Components/ui/table";
import { Edit } from "lucide-react";
import { Link } from "@inertiajs/react";
import { Button } from "@/Components/ui/button";
import { Product } from "@/types/custom";
import { DeleteProduct } from "../../Partials/DeleteProduct";
import ImageGallery from "./ImageGallery";

const ProductTableRow = ({ product }: { product: Product }) => {

    return (
        <>
            <TableCell>
                <ImageGallery images={product.images} />
            </TableCell>
            <TableCell className="font-medium">{product.name}</TableCell>
            <TableCell>{product.description}</TableCell>
            <TableCell>
                {product.price>0?(
                        `${product.price} AF`
                ):null}
            </TableCell>
            <TableCell>
                {product?.category?.name}
            </TableCell>
            <TableCell>
                <div className="flex gap-2 justify-end">
                    <DeleteProduct id={product.id} />
                    <Link href={route('products.edit',product.id)}>
                        <Button variant={"outline"}>
                            <Edit size={18} color="green" />
                        </Button>
                    </Link>
                </div>
            </TableCell>
        </>
    );
};

export default ProductTableRow;
