import { FormEventHandler, useState } from "react";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import InputError from "@/Components/InputError";
import InputLabel from "@/Components/InputLabel";
import PrimaryButton from "@/Components/PrimaryButton";
import TextInput from "@/Components/TextInput";
import { Head, Link, router, usePage } from "@inertiajs/react";
import "react-phone-number-input/style.css";
import { ArrowLeft } from "lucide-react";
import Textarea from "@/Components/Textarea";
import { openEditor } from "react-profile";
import "react-profile/themes/default.min.css";
import { url } from "@/lib/url";

export default function Create({ userId }: { userId: string }) {
    const { errors } = usePage().props;

    const [logo, setLogo] = useState(null);
    const [name, setName] = useState("");
    const [description, setDescription] = useState("");
    const [plan, setPlan] = useState("");

    const handleLogoChange = async (e: React.ChangeEvent<HTMLInputElement>) => {
        if (
            //@ts-ignore
            e.target.files[0].type === "image/jpeg" ||
            //@ts-ignore
            e.target.files[0].type === "image/png"
        ) {
            //@ts-ignore
            const image = await openEditor({ src: e.target.files[0] });
            //@ts-ignore
            setLogo(image?.editedImage?.getDataURL());
        } else {
            console.log("inValid type");
        }
    };

    const handleSubmit = (e: React.FormEvent) => {
        e.preventDefault();
        router.post(route("user.store.store", userId), {
            name,
            description,
            logo,
            plan,
        });
    };

    return (
        <AuthenticatedLayout>
            <Head title="Register" />

            <div className="flex justify-center items-center mt-10">
                <form
                    onSubmit={handleSubmit}
                    className="w-96 bg-white p-7 rounded-lg"
                >
                    <Link href={route("user.store.index", userId)}>
                        <ArrowLeft size={16} className="mb-3" />
                    </Link>

                    <div className="flex justify-center items-center">
                        {logo ? (
                            <img
                                src={`${logo}`}
                                alt="logo"
                                className="w-20 h-20 rounded-md -mt-5"
                            />
                        ) : (
                            <img
                                src={`${url}/images/logo.jpg`}
                                alt="avatar"
                                className="w-20 h-20 rounded-md -mt-5"
                            />
                        )}
                    </div>
                    <div className="mt-2">
                        <InputLabel htmlFor="plan" value="Plan" />
                        <select
                            name="plan"
                            id="plan"
                            className="mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                            value={plan}
                            onChange={(e) => setPlan(e.target.value)}
                            required
                        >
                            <option value="">select plan</option>
                            <option value={5}>5</option>
                            <option value={30}>30</option>
                            <option value={70}>70</option>
                            <option value={100}>100</option>
                        </select>

                        <InputError message={errors.plan} className="mt-2" />
                    </div>

                    <div className="mt-2">
                        <InputLabel htmlFor="name" value="Store Name" />
                        <TextInput
                            id="name"
                            name="name"
                            value={name}
                            className="mt-1 block w-full"
                            autoComplete="name"
                            isFocused={true}
                            onChange={(e) => setName(e.target.value)}
                            required
                        />

                        <InputError message={errors.name} className="mt-2" />
                    </div>
                    <div className="mt-2">
                        <InputLabel
                            htmlFor="description"
                            value="Store Description"
                        />
                        <Textarea
                            id="description"
                            name="description"
                            value={description}
                            className="mt-1 block w-full"
                            autoComplete="description"
                            isFocused={true}
                            onChange={(e: any) =>
                                setDescription(e.target.value)
                            }
                        />

                        <InputError
                            message={errors.description}
                            className="mt-2"
                        />
                    </div>

                    <div className="mt-2">
                        <label
                            htmlFor="logo"
                            className="bg-white text-gray-500 font-semibold rounded max-w-md  h-26 flex flex-col items-center justify-center cursor-pointer border-2 border-gray-300 border-dashed mx-auto font-[sans-serif] text-xs"
                        >
                            <svg
                                xmlns="http://www.w3.org/2000/svg"
                                className="w-11 mb-2 fill-gray-500"
                                viewBox="0 0 32 32"
                            >
                                <path
                                    d="M23.75 11.044a7.99 7.99 0 0 0-15.5-.009A8 8 0 0 0 9 27h3a1 1 0 0 0 0-2H9a6 6 0 0 1-.035-12 1.038 1.038 0 0 0 1.1-.854 5.991 5.991 0 0 1 11.862 0A1.08 1.08 0 0 0 23 13a6 6 0 0 1 0 12h-3a1 1 0 0 0 0 2h3a8 8 0 0 0 .75-15.956z"
                                    data-original="#000000"
                                />
                                <path
                                    d="M20.293 19.707a1 1 0 0 0 1.414-1.414l-5-5a1 1 0 0 0-1.414 0l-5 5a1 1 0 0 0 1.414 1.414L15 16.414V29a1 1 0 0 0 2 0V16.414z"
                                    data-original="#000000"
                                />
                            </svg>
                            Edit Logo
                            <input
                                type="file"
                                id="logo"
                                className="hidden"
                                multiple={false}
                                accept="image/*"
                                onChange={handleLogoChange}
                            />
                            <p className="text-xs font-thin text-gray-400 mt-2 p-2">
                                PNG and JPG are Allowed.
                            </p>
                        </label>

                        <InputError message={errors.images} className="mt-2" />
                    </div>

                    <div className="flex items-center justify-end mt-4">
                        <PrimaryButton type="submit" className="ms-4">
                            Save
                        </PrimaryButton>
                    </div>
                </form>
            </div>
        </AuthenticatedLayout>
    );
}
