import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { Head, Link } from "@inertiajs/react";
import { url } from "@/lib/url";
import { Button } from "@/Components/ui/button";
import { EditIcon, PlusCircle } from "lucide-react";
import { User } from "@/types";
import { Store } from "@/types/custom";

export default function Index({ user, store }: { user: User; store: Store }) {
    return (
        <AuthenticatedLayout>
            <Head title="Links" />

            <div className="py-12">
                <div className="max-w-full md:max-w-3xl mx-auto sm:px-6 lg:px-8">
                    {
                        //@ts-ignore
                        user.store ? (
                            <Link
                                href={
                                    //@ts-ignore
                                    route("store.edit", user.store.id)
                                }
                            >
                                <Button
                                    variant={"outline"}
                                    className="flex gap-1"
                                >
                                    <EditIcon size={14} />
                                    <p>Edit Store Details</p>
                                </Button>
                            </Link>
                        ) : (
                            <Link href={route("store.create")}>
                                <Button
                                    variant={"outline"}
                                    className="flex gap-1"
                                >
                                    <PlusCircle size={14} />
                                    <p>Add Store Details</p>
                                </Button>
                            </Link>
                        )
                    }

                    <div className="bg-white overflow-hidden shadow-sm sm:rounded-lg mt-1">
                        <div className="p-6 text-gray-900">
                            <div className="flex flex-col justify-center items-center">
                                <h3> {store?.name}</h3>
                            </div>
                            <div className="flex flex-col gap-3 mt-3">
                                <div className="bg-slate-100 p-4 rounded-lg">
                                    <div className="flex gap-5 items-center">
                                        <div>
                                            {store?.logo ? (
                                                <img
                                                    src={`${url}/storage/store/${store?.logo}`}
                                                    alt={store?.name}
                                                    className="w-32 h-32 rounded-md"
                                                />
                                            ) : (
                                                <img
                                                    src={`${url}/images/logo.jpg`}
                                                    alt="logo"
                                                    className="w-32 h-32 rounded-md"
                                                />
                                            )}
                                        </div>
                                        <div>
                                            <p>Plan: {store?.plan}</p>
                                            <p className="text-wrap">
                                                {store?.description}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
