import { Button } from "@/Components/ui/button";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { User } from "@/types";
import { Head, Link, router, useForm } from "@inertiajs/react";
import { FilterXIcon, PlusCircle } from "lucide-react";
import {
    Table,
    TableBody,
    TableCaption,
    TableHead,
    TableHeader,
    TableRow,
} from "@/Components/ui/table";
import UserTableRow from "./Partials/UserTableRow";
import TextInput from "@/Components/TextInput";
import Pagination from "@/Components/Pagination";
export default function Index({ users }: { users: User[] }) {
    const { data, setData, get, processing } = useForm({
        search: "",
    });
    const handleUserSearch = (e: React.FormEvent) => {
        e.preventDefault();
        //@ts-ignore
        get(route("users.index"), { data });
    };

    return (
        <AuthenticatedLayout>
            <Head title="Users" />

            <div className="py-12">
                <div className="max-w-full md:max-w-7xl mx-auto sm:px-6 lg:px-8">
                    <div className="flex flex-col sm:flex-row justify-between items-center">
                        <Link href={route("users.create")}>
                            <Button variant={"outline"} className="flex gap-1">
                                <PlusCircle size={14} />
                                <p>Register New User</p>
                            </Button>
                        </Link>
                        <div className="flex gap-2">
                            <Link
                                href={route("users.index")}
                                className="flex justify-center items-center"
                            >
                                <FilterXIcon size={24} color="black" />
                            </Link>
                            <form onSubmit={handleUserSearch}>
                                <TextInput
                                    value={data.search}
                                    onChange={(e) =>
                                        setData({ search: e.target.value })
                                    }
                                    placeholder="Search user name or email..."
                                    className="text-sm w-[250px] mr-1"
                                    required
                                />
                                <Button type="submit" disabled={processing}>
                                    {processing ? "Search..." : "Search"}
                                </Button>
                            </form>
                        </div>
                    </div>
                    <div className="bg-white overflow-hidden shadow-sm sm:rounded-lg mt-1">
                        <div className="p-6 text-gray-900">
                            <Table>
                                <TableCaption>List of users.</TableCaption>
                                <TableHeader>
                                    <TableRow>
                                        <TableHead className="w-[100px]">
                                            Avatar
                                        </TableHead>
                                        <TableHead>Name</TableHead>
                                        <TableHead>Email</TableHead>
                                        <TableHead>Phone</TableHead>
                                        <TableHead>Role</TableHead>
                                        <TableHead>Links</TableHead>
                                        <TableHead>Store</TableHead>
                                        <TableHead className="flex justify-center">
                                            Action
                                        </TableHead>
                                    </TableRow>
                                </TableHeader>
                                <TableBody>
                                    {
                                        //@ts-ignore
                                        users.data.map((user: User) => (
                                            <TableRow key={user.id}>
                                                <UserTableRow user={user} />
                                            </TableRow>
                                        ))
                                    }
                                </TableBody>
                            </Table>
                            <Pagination
                                //@ts-ignore
                                links={users.links}
                            />
                        </div>
                    </div>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
