import {
    AlertDialog,
    AlertDialogAction,
    AlertDialogCancel,
    AlertDialogContent,
    AlertDialogDescription,
    AlertDialogFooter,
    AlertDialogHeader,
    AlertDialogTitle,
    AlertDialogTrigger,
} from "@/Components/ui/alert-dialog";
import { Button } from "@/Components/ui/button";
import { router } from "@inertiajs/react";
import { Trash2 } from "lucide-react";

export function DeleteLink({ id }: { id: string }) {

    function handleDelete(id: any) {
        router.delete(route("userLinks.delete", id), id);
    }

    return (
        <AlertDialog>
            <AlertDialogTrigger asChild>
            <Button variant={"outline"}>
                    <Trash2 size={16} color="red" />
            </Button>
            </AlertDialogTrigger>
            <AlertDialogContent>
                <AlertDialogHeader>
                    <AlertDialogTitle>
                        Are you absolutely sure?
                    </AlertDialogTitle>
                    <AlertDialogDescription>
                        This action cannot be undone. This link permanently
                        will be deleted from your account.
                    </AlertDialogDescription>
                </AlertDialogHeader>
                <AlertDialogFooter>
                    <AlertDialogCancel>Cancel</AlertDialogCancel>
                    <AlertDialogAction 
                        onClick={() => handleDelete(id)}
                        className="bg-red-600 text-white hover:bg-red-800"
                    >
                        Continue
                    </AlertDialogAction>
                </AlertDialogFooter>
            </AlertDialogContent>
        </AlertDialog>
    );
}
