import { Button } from "@/Components/ui/button";
import {
    Dialog,
    DialogContent,
    DialogFooter,
    DialogHeader,
    DialogTitle,
    DialogTrigger,
} from "@/Components/ui/dialog";
import { Input } from "@/Components/ui/input";
import { Edit } from "lucide-react";
import { useForm } from "@inertiajs/react";
import { Label } from "@/Components/ui/label";
import { Media } from "@/types/custom";
import { Transition } from "@headlessui/react";

export default function EditDialogForm({
    userId,
    media,
    svg,
    success
}: {
    userId: string;
    media: Media;
    svg: any;
    success: string
}) {
    const { data, setData, put, processing, errors,recentlySuccessful } = useForm({
        name: media.name,
        title: media.title,
        url: media.url,
        userId: userId,
    });

    const handleSubmit = (e: React.FormEvent) => {
        e.preventDefault();
        put(route("userLinks.update", media.id));
    };

    return (
        <Dialog>
            <DialogTrigger asChild>
                <Button variant={"outline"}>
                    <Edit size={16} color="green" />
                </Button>
            </DialogTrigger>

            <DialogContent className="sm:max-w-[480px]">
           
            <Transition
                 show={recentlySuccessful}
                 enter="transition ease-in-out"
                 enterFrom="opacity-0"
                 leave="transition ease-in-out"
                 leaveTo="opacity-0"
             >
                 <p className="text-sm text-green-600">Updated.</p>
             </Transition>
        

                <form onSubmit={handleSubmit}>
                    <DialogHeader>
                        <div className="flex flex-col gap-1 justify-center items-center">
                            <span>
                                <img src={svg} />
                            </span>
                            <DialogTitle>
                                {media.title.charAt(0).toUpperCase() + media.title.slice(1)}
                            </DialogTitle>
                        </div>
                    </DialogHeader>
                    <div className="grid gap-4 py-4">
                        <div className="grid grid-cols-4 items-center gap-4">
                            <Label htmlFor="title" className="text-right">
                                Link Title
                            </Label>
                            <Input
                                value={data.title}
                                onChange={(e) =>
                                    setData("title", e.target.value)
                                }
                                id="title"
                                placeholder={
                                    media.title.charAt(0).toUpperCase() +
                                    media.title.slice(1)
                                }
                                type="text"
                                className="col-span-3"
                            />
                        </div>
                        <div className="flex justify-center items-center mt-[-12px]">
                            {errors.title && (
                                <p className="text-red-600 text-xs">
                                    {errors.title}
                                </p>
                            )}
                        </div>
                        <div className="grid grid-cols-4 items-center gap-4">
                            <Label htmlFor="url" className="text-right">
                                {media.title.charAt(0).toUpperCase() + media.title.slice(1)}
                                Url
                            </Label>
                            <Input
                                value={data.url}
                                onChange={(e) => setData("url", e.target.value)}
                                id="url"
                                type="text"
                                placeholder={`${
                                    data.name == "whatsapp"
                                        ? "93771234567"
                                        : data.name == "telegram"
                                        ? "zuck"
                                        : data.name == "messenger"
                                        ? "zuck"
                                        : `https://www.${media.title}.com/zuck`
                                }`}
                                className="col-span-3"
                            />
                        </div>
                        <div className="flex justify-center items-center mt-[-12px]">
                            {errors.url && (
                                <p className="text-red-600 text-xs">
                                    {errors.url}
                                </p>
                            )}
                        </div>
                    </div>
                    <DialogFooter>
                        <Button type="submit" disabled={processing}>
                            {processing? 'Updating...' : 'Update'}
                        </Button>
                    </DialogFooter>
                </form>
            </DialogContent>
        </Dialog>
    );
}
