import { Head } from "@inertiajs/react";
import { PageProps } from "@/types";
import { url } from "@/lib/url";
import Footer from "@/Components/Footer";
import Header from "@/Components/Header";
import { useTypewriter } from "react-simple-typewriter";
import {
    Carousel,
    CarouselContent,
    CarouselItem,
    CarouselNext,
    CarouselPrevious,
} from "@/Components/ui/carousel";

export default function Welcome({ auth }: PageProps) {
    const [text] = useTypewriter({
        words: [
            "Grow your business!",
            "Share your social links easily!",
            "Share your products easily!",
        ],
        loop: 0,
    });

    return (
        <>
            <Head title="Welcome" />
            <div className="bg-gray-100 text-black/50 dark:bg-black dark:text-white/50">
                <div className="relative min-h-screen flex flex-col items-center justify-center selection:bg-[#FF2D20] selection:text-white">
                    <div className="relative w-full max-w-2xl px-6 lg:max-w-7xl">
                        <Header auth={auth} />

                        <main className="mt-6">
                            <div className="grid gap-6 lg:grid-cols-2 lg:gap-8 ">
                                <div
                                    id="docs-card"
                                    className="flex flex-col items-start gap-6 overflow-hidden rounded-lg bg-white p-6 shadow-[0px_14px_34px_0px_rgba(0,0,0,0.08)] ring-1 ring-white/[0.05] transition duration-300 hover:text-black/70 hover:ring-black/20 focus:outline-none focus-visible:ring-[#FF2D20] md:row-span-3 lg:p-10 lg:pb-10 dark:bg-zinc-900 dark:ring-zinc-800 dark:hover:text-white/70 dark:hover:ring-zinc-700 dark:focus-visible:ring-[#FF2D20]"
                                >
                                    <div className="relative flex items-center gap-6 lg:items-end">
                                        <div
                                            id="docs-card-content"
                                            className="flex items-start gap-6 lg:flex-col"
                                        >
                                            <div className="pt-3 sm:pt-5 lg:pt-0">
                                                <h2 className="text-xl font-semibold text-blue-700 dark:text-white">
                                                    Ertebatasan (EasyLinks)
                                                </h2>
                                                <p className="mt-4 text-sm/relaxed text-black">
                                                    Imagine a digital hub where
                                                    users effortlessly share all
                                                    their essential contact
                                                    information—telephone
                                                    numbers, emails, and social
                                                    media links—centralized in
                                                    one convenient location,
                                                    enabling seamless
                                                    connectivity with friends,
                                                    family, and colleagues. This
                                                    website empowers users to
                                                    create personalized web
                                                    pages tailored for their
                                                    businesses, allowing for a
                                                    professional online presence
                                                    that highlights their unique
                                                    offerings and services.
                                                    Through user-friendly
                                                    customization tools,
                                                    business owners can design
                                                    web pages that reflect their
                                                    brand identity,
                                                    incorporating elements like
                                                    logos, color schemes, and
                                                    multimedia content to engage
                                                    and attract potential
                                                    clients. This integrated
                                                    platform not only enhances
                                                    communication by
                                                    streamlining how contact
                                                    information is shared and
                                                    accessed but also bolsters
                                                    business visibility in the
                                                    digital landscape. It
                                                    fosters networking
                                                    opportunities by connecting
                                                    individuals and enterprises
                                                    through a unified,
                                                    accessible online
                                                    environment. Users benefit
                                                    from enhanced organization
                                                    and professional
                                                    presentation, making it
                                                    easier for customers to
                                                    reach them through various
                                                    communication channels. By
                                                    leveraging the power of this
                                                    website, users can optimize
                                                    their online interactions,
                                                    build stronger connections,
                                                    and elevate their business
                                                    presence, ultimately
                                                    fostering growth and success
                                                    in today’s digitally-driven
                                                    world. This all-encompassing
                                                    platform becomes an
                                                    indispensable tool for both
                                                    personal and professional
                                                    use, bridging the gap
                                                    between connectivity and
                                                    customization.
                                                </p>
                                                <p className="flex justify-center items-center mt-5 text-black italic font-semibold">
                                                    {text}
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div className="flex items-center justify-center gap-4 rounded-lg bg-white p-6 shadow-[0px_14px_34px_0px_rgba(0,0,0,0.08)] ring-1 ring-white/[0.05] transition duration-300 hover:text-black/70 hover:ring-black/20 focus:outline-none focus-visible:ring-[#FF2D20] lg:pb-10 dark:bg-zinc-900 dark:ring-zinc-800 dark:hover:text-white/70 dark:hover:ring-zinc-700 dark:focus-visible:ring-[#FF2D20]">
                                    <div className="pt-3 sm:pt-5">
                                        <div className="flex justify-center items-center">
                                            <Carousel>
                                                <CarouselContent>
                                                    <CarouselItem>
                                                        <img
                                                            src={`${url}/images/logo.jpg`}
                                                            className="rounded-md h-full"
                                                        />
                                                    </CarouselItem>
                                                    <CarouselItem>
                                                        <img
                                                            src={`${url}/images/socials.jpg`}
                                                            className="rounded-md h-full"
                                                        />
                                                    </CarouselItem>
                                                    <CarouselItem>
                                                        <img
                                                            src={`${url}/images/easy-links.jpg`}
                                                            className="rounded-md h-full"
                                                        />
                                                    </CarouselItem>
                                                    <CarouselItem>
                                                        <img
                                                            src={`${url}/images/mobile.jpg`}
                                                            className="rounded-md h-full"
                                                        />
                                                    </CarouselItem>
                                                </CarouselContent>
                                                <CarouselPrevious />
                                                <CarouselNext />
                                            </Carousel>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </main>

                        <Footer />
                    </div>
                </div>
            </div>
        </>
    );
}
