import { User } from ".";


export type Category ={
    id: string;
    name: string;
    user_id: string;
    user: User
}

export type Contact = {
    id: number;
    name: string;
    email: string;
    subject: string;
    message: string;
};

export type Media = {
    id: string;
    name: string;
    title: string;
    url: string;
    user_id: string;
};

export type Product = {
    id: string;
    name: string;
    description: string;
    price: number;
    images: Array<string>;
    user_id: string;
    store?: Store;
    category_id: string;
    category: Category
};

export type Store = {
    id: string;
    name: string;
    description: string;
    logo: string;
    plan: number;
    user_id: string;
    products: Product[];
    user?: User;
};

