<?php

use App\Http\Controllers\AdminProductController;
use App\Http\Controllers\AdminStoreController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\MediaController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\QrCodeController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ProductDisplayController;
use App\Http\Controllers\StoreController;
use App\Http\Middleware\CheckUserLinkStatusMiddleware;
use App\Http\Middleware\CheckUserProductStatusMiddleware;
use App\Http\Middleware\CheckUserRoleMiddleware;
use Illuminate\Foundation\Application;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

Route::get('/', function () {
    return Inertia::render('Welcome');
});

Route::get('/dashboard', function () {
    return Inertia::render('Dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::get('/contacts/create', [ContactController::class, 'create'])->name('contact.create');
Route::post('/contacts/create', [ContactController::class, 'store'])->name('contact.store');

Route::get('/links', [MediaController::class, 'index'])->middleware(['auth', 'verified'])->name('links')->middleware(CheckUserLinkStatusMiddleware::class);
Route::get('/links-create', [MediaController::class, 'create'])->middleware(['auth', 'verified'])->name('links.create')->middleware(CheckUserLinkStatusMiddleware::class);
Route::post('/links-store', [MediaController::class, 'store'])->middleware(['auth', 'verified'])->name('links.store')->middleware(CheckUserLinkStatusMiddleware::class);
Route::put('/links-update/${id}', [MediaController::class, 'update'])->middleware(['auth', 'verified'])->name('links.update')->middleware(CheckUserLinkStatusMiddleware::class);
Route::delete('/links-delete/{id}', [MediaController::class, 'destroye'])->middleware(['auth', 'verified'])->name('links.delete')->middleware(CheckUserLinkStatusMiddleware::class);
Route::get('/qrcode/{id}', [QrCodeController::class, 'show'])->middleware(['auth', 'verified', CheckUserRoleMiddleware::class])->name('qrcode');
Route::get('/{id}/display', [QrCodeController::class, 'display'])->name('display');
Route::get('/vcard/{id}', [QrCodeController::class, 'downloadVCard'])->name('vcard');
Route::get('/shop/{id}', [ProductDisplayController::class, 'index'])->name('store.display.index');
Route::get('/shop/{store}/{product}', [ProductDisplayController::class, 'show']);
Route::get('/shop-contact/{storeId}', [ProductDisplayController::class, 'contact'])->name('store.contact');


Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::post('/file/{id}', [ProfileController::class, 'file'])->name('profile.file');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::resource('/users', UserController::class)->middleware(CheckUserRoleMiddleware::class);
    Route::get('/users/{id}/links', [UserController::class, 'createUserLinks'])->name('userLinks.create');
    Route::post('/users/links', [UserController::class, 'storeUserLinks'])->name('userLinks.store');
    Route::delete('/users/links/{id}', [UserController::class, 'destroyeUserLinks'])->name('userLinks.delete');
    Route::put('/users/{id}/links', [UserController::class, 'updateUserLinks'])->name('userLinks.update');
    Route::post('/users/media/{id}', [UserController::class, 'updateMediaActiveFeature'])->name('users.media.update');
    Route::post('/users/product/{id}', [UserController::class, 'updateProductActiveFeature'])->name('users.product.update');

    Route::get('/contacts', [ContactController::class, 'index'])->name('contact.index')->middleware(CheckUserRoleMiddleware::class);
    Route::delete('/contacts/{contact}', [ContactController::class, 'destroy'])->name('contact.delete')->middleware(CheckUserRoleMiddleware::class);

    Route::prefix('user/store')->as('user.')->group(function () {
        Route::get('/{user}/store', [AdminStoreController::class, 'index'])->name('store.index');
        Route::get('/{user}/create', [AdminStoreController::class, 'create'])->name('store.create');
        Route::post('/{user}/store', [AdminStoreController::class, 'store'])->name('store.store');
        Route::get('/{store}/edit', [AdminStoreController::class, 'edit'])->name('store.edit');
        Route::put('/{store}/update', [AdminStoreController::class, 'update'])->name('store.update');
    });

    Route::resource('/store', StoreController::class)->except(['show', 'destroy']);

    Route::resource('/products', ProductController::class)->except(['show', 'update'])->middleware(CheckUserProductStatusMiddleware::class);
    Route::post('/products/{product}', [ProductController::class, 'update'])->name('products.update')->middleware(CheckUserProductStatusMiddleware::class);

    Route::get('/products/user/{user}', [AdminProductController::class, 'index'])->name('admin.products.index')->middleware(CheckUserRoleMiddleware::class);
    Route::get('/products/user/{user}/create', [AdminProductController::class, 'create'])->name('admin.products.create')->middleware(CheckUserRoleMiddleware::class);
    Route::post('/products/user/{userId}/store', [AdminProductController::class, 'store'])->name('admin.products.store')->middleware(CheckUserRoleMiddleware::class);
    Route::get('/products/{product}/user/{userId}/edit', [AdminProductController::class, 'edit'])->name('admin.products.edit')->middleware(CheckUserRoleMiddleware::class);
    Route::post('/products/{product}/user/{userId}/update', [AdminProductController::class, 'update'])->name('admin.products.update')->middleware(CheckUserRoleMiddleware::class);
    Route::get('/admin/products', [AdminProductController::class, 'showAllProducts'])->name('admin.products.all')->middleware(CheckUserRoleMiddleware::class);

    Route::resource('/category', CategoryController::class)->except(['show']);
});


require __DIR__ . '/auth.php';
